<main id="main" class="main">

    <div class="pagetitle">
        <h1><i class="bi bi-bootstrap-reboot"></i>&nbsp;RETUR FG</h1>
        <nav>
            <ol class="breadcrumb">

            </ol>
        </nav>
    </div><!-- End Page Title -->
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <br>
                        <!-- Table with stripped rows -->
                        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <input type="date" class="form-control" id="mulai" value="<?= date('Y-m-01'); ?>">
                                </div>
                                <div class="col-md-3">
                                    <input type="date" class="form-control" id="hingga" value="<?= date('Y-m-d'); ?>">
                                </div>
                                <div class="col-md-4">
                                    <button onclick="tampildatakirim()" type="button" class="btn btn-primary">
                                        <i class="bi bi-search"></i>&nbsp;Lihat
                                    </button>
                                    <button type="button" data-bs-toggle="modal" data-bs-target="#f_add_retur" onclick="add_kirim()" class="btn btn-warning">
                                        <i class="bi bi-plus-circle"></i>&nbsp;RETUR
                                    </button>
                                </div>

                            </div>
                            <br>
                            <div class="datatable-container">
                                <div id="tbretur"></div>
                            </div>
                        </div>
                        <!-- End Table with stripped rows -->
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<div class="modal fade" id="f_add_retur" tabindex="-1" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">RETUR</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row mb-6">
                    <label for="inputEmail3" class="col-sm-3 col-form-label">No POL</label>
                    <div class="col-sm-9">
                        <input type="text" class="form-control form-control-sm" id="no_pol_retur">
                    </div>
                </div>
                <div class="row mb-6">
                    <label for="inputEmail3" class="col-sm-3 col-form-label">No SJ Retur</label>
                    <div class="col-sm-9">
                        <input type="text" class="form-control form-control-sm" id="no_sj_retur">
                    </div>
                </div>
                <div class="row mb-6">
                    <label for="inputEmail3" class="col-sm-3 col-form-label">Tanggal</label>
                    <div class="col-sm-9">
                        <input type="date" class="form-control form-control-sm" id="tgl_sj_retur">
                    </div>
                </div>
                <div class="row mb-6">
                    <label for="inputEmail3" class="col-sm-3 col-form-label">Customer</label>
                    <div class="col-sm-9">
                        <input type="text" class="form-control form-control-sm" id="customer_retur">
                    </div>
                </div>
                <div class="row mb-6">
                    <label for="inputEmail3" class="col-sm-3 col-form-label">Keterangan</label>
                    <div class="col-sm-9">
                        <textarea id="ket_retur" class="form-control form-control-sm"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="simpan_retur()">Simpan</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="f_update_retur" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Update retur</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="id_retur">
                <div class="row mb-6">
                    <label for="inputEmail3" class="col-sm-3 col-form-label">No POL</label>
                    <div class="col-sm-9">
                        <input type="text" class="form-control form-control-sm" id="ed_no_pol_retur">
                    </div>
                </div>
                <div class="row mb-6">
                    <label for="inputEmail3" class="col-sm-3 col-form-label">No SJ Retur</label>
                    <div class="col-sm-9">
                        <input type="text" class="form-control form-control-sm" id="ed_no_sj_retur">
                    </div>
                </div>
                <div class="row mb-6">
                    <label for="inputEmail3" class="col-sm-3 col-form-label">Tanggal</label>
                    <div class="col-sm-9">
                        <input type="date" class="form-control form-control-sm" id="ed_tgl_sj_retur">
                    </div>
                </div>
                <div class="row mb-6">
                    <label for="inputEmail3" class="col-sm-3 col-form-label">Customer</label>
                    <div class="col-sm-9">
                        <input type="text" class="form-control form-control-sm" id="ed_customer_retur">
                    </div>
                </div>
                <div class="row mb-6">
                    <label for="inputEmail3" class="col-sm-3 col-form-label">Keterangan</label>
                    <div class="col-sm-9">
                        <textarea id="ed_ket_retur" class="form-control form-control-sm"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-success" onclick="update_retur()">Update</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="f_renumber" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detail LOT retur</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="id_retur_lot">
                <div id="tbreturlot"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    function tampildatakirim() {
        var mulai = $("#mulai").val();
        var hingga = $("#hingga").val();
        $.get("<?= base_url('Qc/tb_retur?s='); ?>" + mulai + "&e=" + hingga, function(data, status) {
            $("#tbretur").html(data);
        });
    }

    function simpan_retur() {
        var no_pol = $("#no_pol_retur").val();
        var no_sj = $("#no_sj_retur").val();
        var tgl = $("#tgl_sj_retur").val();
        var cust = $("#customer_retur").val();
        var ket = $("#ket_retur").val();
        if (no_pol == '') {
            pesan("No Pol Kendaraan mohon diisi", "error");
        } else {
            if (no_sj == '') {
                pesan("No SJ mohon diisi", "error");
            } else {
                if (tgl == '') {
                    pesan("Tanggal mohon diisi", "error");
                } else {
                    $.ajax({
                        url: "<?= base_url('Qc/simpan_retur'); ?>",
                        type: 'POST',
                        cache: false,
                        data: {
                            no_pol: no_pol,
                            no_sj: no_sj,
                            tgl: tgl,
                            cust: cust,
                            ket: ket
                        },
                        success: function() {
                            document.getElementById('no_pol_retur').value = '';
                            document.getElementById('no_sj_retur').value = '';
                            document.getElementById('tgl_sj_retur').value = '';
                            document.getElementById('customer_retur').value = '';
                            document.getElementById('ket_retur').value = '';
                            pesan("Disimpan", "success");
                            tampildatakirim();
                            $("#f_add_retur").modal("hide");
                        }
                    });
                }
            }
        }
    }

    function pesan(txt, jenis) {
        const Toast = Swal.mixin({
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 2000,
            timerProgressBar: false,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            }
        });
        Toast.fire({
            icon: jenis,
            title: txt
        });
    }

    function hapus_retur(id) {
        Swal.fire({
            title: "Hapus data retur",
            text: "Semua data scan akan dihapus",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Ya, hapus!"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "<?= base_url('Qc/delete_retur'); ?>",
                    type: 'POST',
                    cache: false,
                    data: {
                        id: id
                    },
                    success: function() {
                        pesan("Data dihapus", "success");
                        tampildatakirim();
                    }
                });
            }
        });
    }

    function edit(id, nopol, sj, tgl, cust, ket) {
        $("#id_retur").val(id);
        $("#ed_no_pol_retur").val(nopol);
        $("#ed_no_sj_retur").val(sj);
        $("#ed_tgl_sj_retur").val(tgl);
        $("#ed_customer_retur").val(cust);
        $("#ed_ket_retur").val(ket);
    }

    function update_retur() {
        var id = $("#id_retur").val();
        var nopol = $("#ed_no_pol_retur").val();
        var sj = $("#ed_no_sj_retur").val();
        var tgl = $("#ed_tgl_sj_retur").val();
        var cust = $("#ed_customer_retur").val();
        var ket = $("#ed_ket_retur").val();
        $.ajax({
            url: "<?= base_url('Qc/update_retur'); ?>",
            type: 'POST',
            cache: false,
            data: {
                id: id,
                nopol: nopol,
                sj: sj,
                tgl: tgl,
                cust: cust,
                ket: ket
            },
            success: function() {
                pesan("Disimpan", "success");
                tampildatakirim();
                $("#f_update_retur").modal("hide");
            }
        });
    }

    function trace_lot_number(id, sku) {
        $.get("<?= base_url('Qc/tb_detail_lot_retur?id='); ?>" + id + "&sku=" + sku, function(data, status) {
            $("#tbreturlot").html(data);
        });
        $("#f_renumber").modal("show");
    }

    function bikin_lot_baru() {
        var id = $("#id_retur_lot").val();
        var sku = $("#sku_lot").val();
        var bj = $("#bj").val();
        var rusak = $("#rusak").val();
        var qty_lot = $("#qty_lot").val();
        total = parseInt(bj) + parseInt(rusak);
        if (bj == '') {
            pesan('Total Barang jadi mohon diisi', 'error');
        } else {
            if (rusak == '') {
                pesan('Total Barang rusak mohon diisi', 'error');
            } else {
                if (parseInt(total) > parseInt(qty_lot)) {
                    pesan('Total Barang tidak diperbolehkan', 'error');
                } else {
                    if (parseInt(total) < parseInt(qty_lot)) {
                        pesan('Total Barang tidak diperbolehkan', 'error');
                    } else {
                        $.ajax({
                            url: "<?= base_url('Qc/renumber_lot'); ?>",
                            type: 'POST',
                            cache: false,
                            data: {
                                id: id,
                                sku: sku,
                                bj: bj,
                                rusak: rusak
                            },
                            success: function() {
                                document.getElementById('bj').value = '';
                                document.getElementById('rusak').value = '';
                                $("#f_renumber").modal("hide");
                                pesan("Disimpan", "success");
                                tampildatakirim();
                            }
                        });
                    }
                }
            }
        }
    }

    function selesai(id) {
        Swal.fire({
            title: "Apakah retur ini sudah selesai ?",
            //text: "You won't be able to revert this!",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Ya, selesai"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "<?= base_url('Qc/retur_selesai'); ?>",
                    type: 'POST',
                    cache: false,
                    data: {
                        id: id
                    },
                    success: function() {
                        pesan("Retur selesai", "success");
                        tampildatakirim();
                    }
                });
            }
        });
    }
</script>