<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Prview | LPBJ</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        header {
            background-color: #4CAF50;
            color: white;
            padding: 1px 20px;
            text-align: center;
        }

        table {
            width: 98%;
            border-collapse: collapse;
            margin: 20px auto;
        }

        th,
        td {
            border: 1px solid #dddddd;
            text-align: left;
            padding: 4px;
        }

        th {
            background-color: #f2f2f2;
        }

        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
    </style>
</head>

<body>
    <header>
        <h1>LEMBAR PENGAJUAN BARANG DAN JASA</h1>
    </header>

    <main>
        <table>
            <thead>
                <tr>
                    <th colspan="2">No LPBJ</th>
                    <td colspan="8"><?= $lpbj; ?></td>
                </tr>
                <tr>
                    <?php
                    $tgl = new DateTime($head['tgl_lpbj']);
                    $fotmattgl = $tgl->format('j M Y');
                    ?>
                    <th colspan="2">Tanggal</th>
                    <td colspan="8"><?= $fotmattgl; ?></td>
                </tr>
                <tr>
                    <th colspan="2">Bagian / Divisi</th>
                    <td colspan="8"><?= $head['unit']; ?></td>
                </tr>
                <tr>
                    <td colspan="10" style="text-align: center;"><b>Detail LPBJ</b></td>
                </tr>
                <tr>
                    <th>#</th>
                    <th>Kode Barang</th>
                    <th>Nama Barang</th>
                    <th>Dept</th>
                    <th width="50px">Jumlah</th>
                    <th width="50px">Satuan</th>
                    <th width="50px">Stok</th>
                    <th>Keterangan</th>
                    <th width="50px">Status</th>
                    <th>Prioritas</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $i = 1;
                foreach ($dtl as $d) {
                    $pesan_apprv = $this->M_Lpbj->sts_aprv_lpbj($lpbj, $d['doc_id']);
                    $sts_apprv = $this->M_Lpbj->sts_aprv_lpbj_2($lpbj, $d['doc_id']);
                    if ($cari_apprv->num_rows() == 0) {
                        echo "<tr>";
                        echo "<td style='vertical-align: text-top;'>" . $i . "</td>";
                        echo "<td style='vertical-align: text-top;'>" . $d['kd_brg'] . "</td>";
                        echo "<td style='vertical-align: text-top;'>" . $d['barang'] . "</td>";
                        echo "<td style='vertical-align: text-top;'>" . $d['nama_dept'] . "</td>";
                        echo "<td style='text-align: right;vertical-align: text-top;'>" . $d['qty_req'] . "</td>";
                        echo "<td style='vertical-align: text-top;'>" . $d['uom'] . "</td>";
                        echo "<td style='text-align: right;vertical-align: text-top;'>" . $d['stok'] . "</td>";
                        echo "<td>";
                        echo "Req : " . $d['keterangan'];
                        foreach ($pesan_apprv as $p) {
                            echo "<br>" . $p['keterangan'];
                        }
                        echo "</td>";
                        echo "<td style='vertical-align: text-top;'><label>Disetujui</label></td>";
                        echo "<td style='vertical-align: text-top;'>" . $d['tanggal_lpbj'] . "</td>";
                        echo "<tr>";
                    }

                    if ($cari_apprv->num_rows() > 0) {
                        foreach ($sts_apprv as $sts2) {
                            if ($sts2['apprv_sts'] == 2 || $sts2['apprv_sts'] == 1) {
                                echo "<tr>";
                                echo "<td style='vertical-align: text-top;'>" . $i . "</td>";
                                echo "<td style='vertical-align: text-top;'>" . $d['kd_brg'] . "</td>";
                                echo "<td style='vertical-align: text-top;'>" . $d['barang'] . "</td>";
                                echo "<td style='vertical-align: text-top;'>" . $d['nama_dept'] . "</td>";
                                echo "<td style='text-align: right;vertical-align: text-top;'>" . $d['qty_req'] . "</td>";
                                echo "<td style='vertical-align: text-top;'>" . $d['uom'] . "</td>";
                                echo "<td style='text-align: right;vertical-align: text-top;'>" . $d['stok'] . "</td>";
                                echo "<td>";
                                echo "Req : " . $d['keterangan'];
                                foreach ($pesan_apprv as $p) {
                                    echo "<br>" . $p['keterangan'];
                                }
                                echo "</td>";
                                echo "<td style='vertical-align: text-top;'><label>Disetujui</label></td>";
                                echo "<td style='vertical-align: text-top;'>" . $d['tanggal_lpbj'] . "</td>";
                                echo "<tr>";
                            }
                            if ($sts2['apprv_sts'] == 0) { // void
                                echo "<tr>";
                                echo "<td style='vertical-align: text-top;color:red;'>" . $i . "</td>";
                                echo "<td style='vertical-align: text-top;color:red;'>" . $d['kd_brg'] . "</td>";
                                echo "<td style='vertical-align: text-top;color:red;'>" . $d['barang'] . "</td>";
                                echo "<td style='vertical-align: text-top;color:red;'>" . $d['nama_dept'] . "</td>";
                                echo "<td style='text-align: right;vertical-align: text-top;color:red;'>" . $d['qty_req'] . "</td>";
                                echo "<td style='vertical-align: text-top;color:red;'>" . $d['uom'] . "</td>";
                                echo "<td style='text-align: right;vertical-align: text-top;color:red;'>" . $d['stok'] . "</td>";
                                echo "<td style='vertical-align: text-top;color:red;'>";
                                echo "Req : " . $d['keterangan'];
                                foreach ($pesan_apprv as $p) {
                                    echo "<br>" . $p['keterangan'];
                                }
                                echo "</td>";
                                echo "<td style='vertical-align: text-top;'><label style='color:red;vertical-align: text-top;'>Ditolak</label></td>";
                                echo "<td style='vertical-align: text-top;color:red;'>" . $d['tanggal_lpbj'] . "</td>";
                                echo "<tr>";
                            }
                        }
                    }
                    $i++;
                }
                ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="10">&nbsp;</td>
                </tr>
                <tr>
                    <td colspan="2" style="text-align: center;"><b>Mengetahui</b></td>
                    <td colspan="2" style="text-align: center;"><b>Menyetujui</b></td>
                    <td colspan="3" style="text-align: center;"><b>Memeriksa</b></td>
                    <td colspan="3" style="text-align: center;"><b>Diajukan Oleh<br><?= $fotmattgl; ?></b></td>
                </tr>
                <tr>
                    <?php
                    $id_spv = $this->M_Lpbj->tb_icon_apprv($lpbj, $datauser['id_spv']);
                    $id_mgr = $this->M_Lpbj->tb_icon_apprv($lpbj, $datauser['id_manager']);
                    $id_dir = $this->M_Lpbj->tb_icon_apprv($lpbj, $datauser['id_direktur']);
                    ?>
                    <td colspan="2" style="text-align: center;" height="60px"><?php if (isset($id_dir['emp_id'])) {
                                                                                    echo "<img width='100px' src='" . base_url('assets/img/apprv.png') . "'>";
                                                                                } ?></td>
                    <td colspan=" 2" style="text-align: center;" height="60px"><?php if (isset($id_mgr['emp_id'])) {
                                                                                    echo "<img width='100px' src='" . base_url('assets/img/apprv.png') . "'>";
                                                                                } ?></td>
                    <td colspan=" 3" style="text-align: center;" height="60px"><?php if (isset($id_spv['emp_id'])) {
                                                                                    echo "<img width='100px' src='" . base_url('assets/img/apprv.png') . "'>";
                                                                                } ?></td>
                    <td colspan="3" style="text-align: center;" height="60px"></td>
                </tr>
                <tr>
                    <td colspan="2" style="text-align: center;"><b><?= $datauser['nama_direktur']; ?></b></td>
                    <td colspan="2" style="text-align: center;"><b><?= $datauser['nama_manager']; ?></b></td>
                    <td colspan="3" style="text-align: center;"><b><?= $datauser['nama_spv']; ?></b></td>
                    <td colspan="3" style="text-align: center;"><b><?= $datauser['FullName']; ?></b></td>
                </tr>
            </tfoot>
        </table>
    </main>
</body>

</html>