<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>TPC-PACK</title>
    <meta content="" name="description">
    <meta content="" name="keywords">

    <!-- Favicons -->
    <link href="images/icons/lux-favico-3-1.png" rel="icon">
    <link href="images/icons/lux-favico-3-1.png rel=" apple-touch-icon">

    <!-- Google Fonts -->
    <link href="https://fonts.gstatic.com" rel="preconnect">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

    <!-- Vendor CSS Files -->
    <link href="<?= base_url(); ?>assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?= base_url(); ?>assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">

    <link href="<?= base_url(); ?>assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
    <link href="<?= base_url(); ?>assets/vendor/quill/quill.snow.css" rel="stylesheet">
    <link href="<?= base_url(); ?>assets/vendor/quill/quill.bubble.css" rel="stylesheet">
    <link href="<?= base_url(); ?>assets/vendor/remixicon/remixicon.css" rel="stylesheet">
    <link href="<?= base_url(); ?>assets/vendor/simple-datatables/style.css" rel="stylesheet">

    <!-- Template Main CSS File -->
    <link href="<?= base_url(); ?>assets/css/style.css" rel="stylesheet">
    <link href="<?= base_url(); ?>assets/css/sweetalert.css" rel="stylesheet">
    <link href="<?= base_url(); ?>assets/css/sweetalert2.min.css" rel="stylesheet">


</head>

<body>

    <!-- ======= Header ======= -->
    <header id="header" class="header fixed-top d-flex align-items-center">

        <div class="d-flex align-items-center justify-content-between">
            <a href="<?= base_url('Home') ?>" class="logo d-flex align-items-center">
                <img src="assets/img/logo.png" alt="">
                <span class="d-none d-lg-block">TPC PACK</span>
            </a>
            <i class="bi bi-list toggle-sidebar-btn"></i>
        </div><!-- End Logo -->

        <div class="search-bar">
            <form class="search-form d-flex align-items-center" method="POST" action="#">

            </form>
        </div><!-- End Search Bar -->

        <nav class="header-nav ms-auto">
            <ul class="d-flex align-items-center">

                <li class="nav-item dropdown">

                    <a class="nav-link nav-icon" href="#" data-bs-toggle="dropdown">

                    </a><!-- End Notification Icon -->

                </li><!-- End Notification Nav -->

                <li class="nav-item dropdown pe-3">

                    <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
                        <span class="d-none d-md-block dropdown-toggle ps-2"><?= $this->session->strNama; ?></span>
                    </a><!-- End Profile Iamge Icon -->

                    <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">

                        <li>
                            <a class="dropdown-item d-flex align-items-center" href="#">
                                <i class="bi bi-file-earmark-person"></i>
                                <span>ID <?= $this->session->id_user; ?></span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center" href="#">
                                <i class="bi bi-geo-alt"></i>
                                <span>Lokasi <?= $this->session->strKdLokasi; ?></span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center" href="<?= base_url('Auth/signout'); ?>">
                                <i class="bi bi-box-arrow-right"></i>
                                <span>Keluar</span>
                            </a>
                        </li>

                    </ul><!-- End Profile Dropdown Items -->
                </li><!-- End Profile Nav -->

            </ul>
        </nav><!-- End Icons Navigation -->

    </header><!-- End Header --><!-- ======= Sidebar ======= -->
    <aside id="sidebar" class="sidebar">

        <ul class="sidebar-nav" id="sidebar-nav">
            <?php
            foreach ($grup as $g) {
                if ($g['subgrup'] == 1) {
            ?>
                    <li class="nav-item">
                        <a class="nav-link collapsed" href="<?= base_url() . $g['url']; ?>">
                            <i class="bi bi-<?= $g['icon']; ?>"></i>
                            <span><?= $g['grup']; ?></span>
                        </a>
                    </li>
            <?php
                }
            }
            ?>

            <?php
            foreach ($grup as $g) {
                if ($g['subgrup'] == 2) {
            ?>
                    <li class="nav-item">
                        <a class="nav-link collapsed" data-bs-target="#components-<?= $g['grup']; ?>" data-bs-toggle="collapse" href="#">
                            <i class="bi bi-<?= $g['icon']; ?>"></i><span><?= $g['grup']; ?></span><i class="bi bi-chevron-down ms-auto"></i>
                        </a>
                        <ul id="components-<?= $g['grup']; ?>" class="nav-content collapse " data-bs-parent="#sidebar-nav">
                            <?php
                            foreach ($sub as $s) {
                                if ($s['id_grup'] == $g['id_grup']) {
                                    foreach ($usr as $u) {
                                        if ($u['id_sub'] == $s['id_sub']) {
                                            if ($u['akses'] == 1) {
                            ?>
                                                <li>
                                                    <a href="<?= base_url() . $s['url']; ?>">
                                                        <i class="bi bi-circle"></i><span><?= $s['submenu']; ?></span>
                                                    </a>
                                                </li>
                                <?php
                                            }
                                        }
                                    }
                                }
                                ?>
                            <?php
                            }
                            ?>
                        </ul>
                    </li>
            <?php
                }
            }
            ?>
            <li class="nav-item">
                <a class="nav-link collapsed" href="<?= base_url('Auth/signout'); ?>">
                    <i class="bi bi-box-arrow-right"></i>
                    <span>Keluar</span>
                </a>
            </li>
            <!-- End Profile Page Nav -->

        </ul>

    </aside><!-- End Sidebar-->


    <div class="modal fade" id="basicModal" tabindex="-1" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Ubah Sandi</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-12">
                            <label class="form-label">Sandi lama anda</label>
                            <input type="password" class="form-control" id="strSandiLama">
                        </div>
                        <div class="col-12">
                            <label class="form-label">Sandi baru anda</label>
                            <input type="password" class="form-control" id="strSandiBaru">
                        </div>
                        <div class="col-12">
                            <label class="form-label">Ulangi sandi baru anda</label>
                            <input type="password" class="form-control" id="strSandiKonfirmasi">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="button" class="btn btn-primary" onclick="ubahsandi()">Simpan</button>
                </div>
            </div>
        </div>
    </div>


    <script>
        function ubahsandi() {
            var strSandiLama = $("#strSandiLama").val();
            var strSandiBaru = $("#strSandiBaru").val();
            var strSandiKonfirmasi = $("#strSandiKonfirmasi").val();
            if (strSandiLama == "") {
                Swal.fire({
                    title: "Sandi lama harus diisi",
                    icon: "Warning"
                });
            } else {
                if (strSandiBaru == "") {
                    Swal.fire({
                        title: "Sandi baru harus diisi",
                        icon: "Warning"
                    });
                } else {
                    if (strSandiKonfirmasi == "") {
                        Swal.fire({
                            title: "Sandi konfirmasi harus diisi",
                            icon: "Warning"
                        });
                    } else {
                        $.ajax({
                            url: "pengaturan/ubahsandi/simpan.ubah.sandi2.php",
                            type: 'POST',
                            cache: false,
                            data: {
                                strSandiLama: strSandiLama,
                                strSandiBaru: strSandiBaru,
                                strSandiKonfirmasi: strSandiKonfirmasi
                            },
                            success: function(data) {
                                if (data == 1) {
                                    Swal.fire({
                                        title: "Sandi telah diubah",
                                        icon: "success"
                                    });
                                    $("#basicModal").modal("hide");
                                    document.getElementById('strSandiLama').value = "";
                                    document.getElementById('strSandiBaru').value = "";
                                    document.getElementById('strSandiKonfirmasi').value = "";
                                } else {
                                    if (data == 0) {
                                        Swal.fire({
                                            title: "Sandi gagal diubah",
                                            icon: "warning"
                                        });
                                    }
                                }
                            }
                        });
                    }
                }
            }

        }
    </script>