<?php
$leftMargin = 10;
$topMargin = 5;
$rightMargin = 1;
$bottomMargin = 1;
$custom_format = [241.3, 279.4];
$pdf = new TCPDF('P', 'mm', $custom_format, true, 'UTF-8', false);
$pdf->SetMargins($leftMargin, $topMargin, $rightMargin);
$pdf->SetAutoPageBreak(false, $bottomMargin);
$pdf->AddPage();
$img_file = './assets/img/kami2.png';
$pdf->Image($img_file, 100, 50, 50, 50, '', '', '', false, 10, '', false, false, 0);
$pdf->SetAlpha(0.5);
$pdf->SetFont('', 'B', 20);
$pdf->Cell(177, 10, "DELIVERY NOTE", 0, 0, 'L');
$pdf->SetFont('', 'B', 20);
$pdf->Ln();
$pdf->SetFont('', '', 12);
$pdf->Cell(197, 5, "Tanggal : " . $head['tgl_sj'], 0, 1, 'L');
$pdf->Cell(197, 5, "No DN : " . $head['no_sj'], 0, 1, 'L');
$pdf->Cell(90, 8, "", 0, 0, 'L');
$pdf->Cell(109, 8, "Kepada : " . $head['id_customer'], 1, 1, 'L');
$pdf->Cell(90, 8, "", 0, 0, 'L');
$pdf->MultiCell(109, 5, $head['keterangan'], 1, '', 0, 1, '', '', true);
$pdf->Cell(90, 8, "", 0, 0, 'L');
$pdf->Cell(109, 8, $head['kota'], 1, 1, 'L');
$pdf->Ln(10);
$pdf->SetFont('', 'B', 12);
$pdf->Cell(10, 8, "No", 1, 0, 'C');
$pdf->Cell(26, 8, "KUANTITAS", 1, 0, 'C');
$pdf->Cell(163, 8, "NAMA BARANG", 1, 1, 'C');
$pdf->SetFont('', '', 12);
$i = 1;
$total = 0;
foreach ($detail as $d) {
    $pdf->Cell(10, 6, $i, 1, 0, 'C');
    $pdf->Cell(26, 6, $d['hitung'] . " DOS", 1, 0, 'R');
    $pdf->Cell(163, 6, $d['barang'], 1, 1, 'L');
    $i++;
    $total += $d['hitung'];
}
$pdf->SetFont('', 'B', 12);
$pdf->Cell(50, 5, "Dibuat oleh :", 0, 0, 'L');
$pdf->Cell(50, 5, "Disiapkan oleh :", 0, 0, 'L');
$pdf->Cell(50, 5, "Dikirim oleh :", 0, 0, 'L');
$pdf->Cell(50, 5, "Diterima oleh :", 0, 1, 'L');

$pdf->Output('Surat_jalan.pdf', 'I');
