<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Sub_nganjuk extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }

        $this->load->library('Pdf');
        $this->load->model('M_sql');
        $this->load->model('M_sub_nganjuk');
        $this->load->model('M_pengaturan');
    }

    public function scan_out()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 44, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('sub_nganjuk/scan_out');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function cari_kode_kirim()
    {
        $id = $this->input->get('kode');
        $data = $this->db->get_where('tb_scan_out', ['no_lot' => $id, 'gudang_asal' => '5']);
        echo $data->num_rows();
    }

    public function cari_kode_kirim1()
    {
        $kode = $this->input->get('kode');
        $hasil = $this->db->query("select count(kode_fg) as kode_fg 
        from tb_fg_gudang 
        where kode_fg = '$kode' and tgl_transfer is not null;")->row_array();
        echo $hasil['kode_fg'];
    }

    public function kode_kirim_simpan()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->session->id_user;
        $kode = $this->input->post('kode_fg');
        $idproduksi = $this->db->get_where('tb_fg_gudang', ['kode_fg' => $kode])->row_array();;
        $data = array(
            'no_lot' => $kode,
            'gudang_asal' => '5',
            'gudang_tujuan' => '1',
            'id_user' => $id,
            'id_produksi' => $idproduksi['id_produksi'],
            'scan_time' => date('Y-m-d H:i:s')
        );
        $this->db->insert('tb_scan_out', $data);
    }

    public function tb_scan_out_daily()
    {
        $tgl = $this->input->get('tgl');
        $data = $this->M_sub_nganjuk->tb_scan_out($tgl);
        $this->load->view('sub_nganjuk/tb_scan_out_daily', ['data' => $data]);
    }

    public function scan_in()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 47, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('sub_nganjuk/scan_in');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function cari_kode_terima()
    {
        $id = $this->input->get('kode');
        $data = $this->db->get_where('tb_scan_mutasi', ['no_lot' => $id]);
        echo $data->num_rows();
    }

    public function simpan_penerimaan()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->session->id_user;
        $kode = $this->input->post('kode_fg');
        $idproduksi = $this->db->get_where('tb_fg_gudang', ['kode_fg' => $kode])->row_array();;
        $data = array(
            'no_lot' => $kode,
            'gudang_asal' => '5',
            'gudang_tujuan' => '0',
            'sj_terima' => $idproduksi['no_sj'],
            'id_user' => $id,
            'id_produksi' => $idproduksi['id_produksi'],
            'scan_time' => date('Y-m-d H:i:s'),
            'sts_lot' => 1
        );
        $this->db->insert('tb_scan_mutasi', $data);
    }

    public function tb_scan_in_daily()
    {
        $tgl = $this->input->get('tgl');
        $data = $this->M_sub_nganjuk->tb_scan_in($tgl);
        $this->load->view('sub_nganjuk/tb_scan_in_daily', ['data' => $data]);
    }
}
