<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Sub_klero extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }

        $this->load->model('M_sql');
        $this->load->model('M_sub_klero');
        $this->load->model('M_pengaturan');
    }

    public function scan_in()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 39, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('sub_klero/scan_in');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function cari_kode_terima()
    {
        $id = $this->input->get('kode');
        $data = $this->db->get_where('tb_scan_mutasi', ['no_lot' => $id]);
        echo $data->num_rows();
    }

    public function simpan_penerimaan()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->session->id_user;
        $kode = $this->input->post('kode_fg');
        $idproduksi = $this->db->get_where('tb_fg_gudang', ['kode_fg' => $kode])->row_array();;
        $data = array(
            'no_lot' => $kode,
            'gudang_asal' => '3',
            'gudang_tujuan' => '0',
            'sj_terima' => $idproduksi['no_sj'],
            'id_user' => $id,
            'id_produksi' => $idproduksi['id_produksi'],
            'scan_time' => date('Y-m-d H:i:s'),
            'sts_lot' => 1
        );
        $this->db->insert('tb_scan_mutasi', $data);
    }

    public function tb_scan_in_daily()
    {
        $tgl = $this->input->get('tgl');
        $data = $this->M_sub_klero->tb_scan_in($tgl);
        $this->load->view('sub_klero/tb_scan_in_daily', ['data' => $data]);
    }

    public function pengiriman()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 40, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $kota = $this->db->get('tb_kota')->result_array();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('sub_klero/pengiriman', ['kota' => $kota]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_pengiriman()
    {
        $s = $this->input->get("s");
        $e = $this->input->get("e");
        $data = $this->M_sub_klero->tb_pengiriman($s, $e);
        $this->load->view('sub_klero/tb_pengiriman', ['data' => $data]);
    }

    public function simpan_do()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->session->id_user;
        $no_pol = $this->input->post('no_pol');
        $sopir = $this->input->post('sopir');
        $km_pergi = $this->input->post('km_pergi');
        $tgl_pergi = $this->input->post('tgl_pergi');
        $keterangan = $this->input->post('keterangan');
        $data = array(
            'id_kendaraan' => $no_pol,
            'id_sopir' => $sopir,
            'km_pergi' => $km_pergi,
            'tgl_pergi' => $tgl_pergi,
            'keterangan' => $keterangan,
            'cr_id' => $id,
            'cr_date' => date('Y-m-d H:i:s'),
            'sts_pengiriman' => 0,
            'unit' => 'KL'
        );
        $this->db->insert('tb_ritase', $data);
    }

    public function hapus_sj()
    {
        $id = $this->input->post('id');
        $this->M_sub_klero->hapus_sj_all($id);
        $this->db->delete('tb_ritase', ['id_rit' => $id]);
        $this->db->delete('tb_sj', ['id_rit' => $id]);
    }

    public function rit_balik()
    {
        $id_rit = $this->input->post('id_rit');
        $tgl_kembali = $this->input->post('tgl_kembali');
        $km_kembali = $this->input->post('km_kembali');
        $data = array(
            'tgl_kembali' => $tgl_kembali,
            'km_kembali' => $km_kembali
        );

        $this->db->where('id_rit', $id_rit);
        $this->db->update('tb_ritase', $data);
    }

    public function update_pengiriman()
    {
        $id_rit = $this->input->post('id_rit');
        $no_pol = $this->input->post('no_pol');
        $sopir = $this->input->post('sopir');
        $tgl_pergi = $this->input->post('tgl_pergi');
        $km_pergi = $this->input->post('km_pergi');
        $keterangan = $this->input->post('keterangan');

        if ($no_pol <> 0) {
            $data = array(
                'id_kendaraan' => $no_pol
            );
            $this->db->where('id_rit', $id_rit);
            $this->db->update('tb_ritase', $data);
        }

        if ($sopir <> '0') {
            $data = array(
                'id_sopir' => $sopir
            );
            $this->db->where('id_rit', $id_rit);
            $this->db->update('tb_ritase', $data);
        }


        $data = array(
            'tgl_pergi' => $tgl_pergi,
            'km_pergi' => $km_pergi,
            'keterangan' => $keterangan
        );

        $this->db->where('id_rit', $id_rit);
        $this->db->update('tb_ritase', $data);
    }

    public function available_truck()
    {
        $kendaraan = $this->M_sub_klero->available_truck();
        echo "<option value='0'>--Pilih Kendaraan--</option>";
        foreach ($kendaraan as $k) {
            echo "<option value='" . $k['id_kendaraan'] . "'>" . $k['no_pol'] . "</option>";
        }
    }

    public function available_driver()
    {
        $sopir = $this->M_sub_klero->available_driver();
        echo "<option value='0'>--Pilih Sopir--</option>";
        foreach ($sopir as $s) {
            echo "<option value='" . $s['emp_id'] . "'>" . $s['FullName'] . "</option>";
        }
    }

    public function tb_expedisi()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $exp = $this->M_sub_klero->tb_expedisi($s, $e);
        $this->load->view('sub_klero/tb_exp', ['exp' => $exp]);
    }

    public function kirim_customer()
    {
        $id = $this->input->post('id');
        $data = array(
            'sts_pengiriman' => 1
        );

        $this->db->where('id_rit', $id);
        $this->db->update('tb_ritase', $data);
    }

    public function simpan_sj()
    {
        $id_rit_sj = $this->input->post('id_rit_sj');
        $no_sj = $this->input->post('no_sj');
        $customer = $this->input->post('customer');
        $kota = $this->input->post('kota');
        $dklk = $this->input->post('dklk');
        $ket_sj = $this->input->post('ket_sj');
        $data = array(
            'id_rit' => $id_rit_sj,
            'no_sj' => $no_sj,
            'id_customer' => $customer,
            'kota' => $kota,
            'dk_lk' => $dklk,
            'keterangan' => $ket_sj
        );

        $this->db->insert('tb_sj', $data);
    }

    public function update_sj()
    {
        $doc_sj = $this->input->post('doc_sj');
        $no_sj = $this->input->post('no_sj');
        $customer = $this->input->post('customer');
        $kota = $this->input->post('kota');
        $dklk = $this->input->post('dklk');
        $ket_sj = $this->input->post('ket_sj');
        $data = array(
            'no_sj' => $no_sj,
            'id_customer' => $customer,
            'kota' => $kota,
            'dk_lk' => $dklk,
            'keterangan' => $ket_sj
        );

        $this->db->where('doc_sj', $doc_sj);
        $this->db->update('tb_sj', $data);
    }

    public function hapus_surat_jalan()
    {
        $id = $this->input->post('id');
        $this->db->delete('tb_sj', ['doc_sj' => $id]);
        $data = [
            'sj_kirim' => NULL,
            'scan_out' => NULL
        ];
        $this->db->where('sj_kirim', $id);
        $this->db->update('tb_scan_mutasi', $data);
    }

    public function hapus_fg_pengiriman()
    {
        $sku = $this->input->post('sku');
        $sj = $this->input->post('sj');
        $this->M_sub_klero->hapus_sj($sj, $sku);
    }

    public function get_available_sj()
    {
        $sj = $this->input->get('sj');
        $data = $this->M_sub_klero->get_available_sj($sj);
        foreach ($data as $dt) {
            echo "<option value='" . $dt['doc_sj'] . "'>" . $dt['no_sj'] . "</option>";
        }
    }

    public function pindah_fg_pengiriman()
    {
        $sku = $this->input->post('sku');
        $sj = $this->input->post('sj');
        $pindah_sj = $this->input->post('pindah_sj');
        $data = array(
            'no_sj' => $pindah_sj
        );

        $this->db->where('sku', $sku);
        $this->db->where('no_sj', $sj);
        $this->db->update('tb_fg_gudang', $data);
    }

    public function simpan_expedisi()
    {
        $no_pol = $this->input->post('no_pol');
        $no_resi = $this->input->post('no_resi');
        $customer = $this->input->post('customer');
        $ket_sj = $this->input->post('ket_sj');
        $tgl = $this->input->post('tgl');
        $data = array(
            'no_pol' => $no_pol,
            'no_resi' => $no_resi,
            'customer' => $customer,
            'keterangan' => $ket_sj,
            'tgl_pergi' => $tgl,
            'sts_pengiriman' => 0,
            'unit' => 'KL'
        );
        $this->db->insert('tb_ritase', $data);
    }

    public function simpan_sj_exp()
    {
        $id_rit_sj = $this->input->post('id_rit_sj');
        $no_sj = $this->input->post('no_sj');
        $ket_sj = $this->input->post('ket_sj');
        $data = array(
            'id_rit' => $id_rit_sj,
            'no_sj' => $no_sj,
            'keterangan' => $ket_sj
        );

        $this->db->insert('tb_sj', $data);
    }

    public function update_sj_exp()
    {
        $doc_sj = $this->input->post('doc_sj');
        $no_sj = $this->input->post('no_sj');
        $ket_sj = $this->input->post('ket_sj');
        $data = array(
            'no_sj' => $no_sj,
            'keterangan' => $ket_sj
        );

        $this->db->where('doc_sj', $doc_sj);
        $this->db->update('tb_sj', $data);
    }

    public function update_exp()
    {
        $id = $this->input->post('id');
        $nopol = $this->input->post('nopol');
        $tgl = $this->input->post('tgl');
        $resi = $this->input->post('resi');
        $cust = $this->input->post('cust');
        $ket = $this->input->post('ke');
        $data = array(
            'no_pol' => $nopol,
            'tgl_pergi' => $tgl,
            'no_resi' => $resi,
            'customer' => $cust,
            'keterangan' => $ket
        );

        $this->db->where('id_rit', $id);
        $this->db->update('tb_ritase', $data);
    }

    public function scan_kirim()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 41, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('sub_klero/scan_kirim');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_scan_kirim()
    {
        $data = $this->M_sub_klero->loading_kirim();
        $this->load->view('sub_klero/tb_scan_kirim', ['data' => $data]);
    }

    public function cari_kode_kirim1()
    {
        $kode = $this->input->get('kode');
        $hasil = $this->db->query("select count(kode_fg) as kode_fg 
        from tb_fg_gudang 
        where kode_fg = '$kode';")->row_array();
        echo $hasil['kode_fg'];
    }

    public function cari_kode_kirim2()
    {
        $kode = $this->input->get('kode');
        $hasil = $this->db->query("SELECT COUNT(no_lot) AS lot
        FROM tb_scan_mutasi 
        WHERE no_lot = '$kode' AND scan_out IS NOT NULL
        ORDER BY no_lot;")->row_array();
        echo $hasil['lot'];
    }

    public function simpan_kirim()
    {
        date_default_timezone_set('Asia/Jakarta');
        $lot = $this->input->post('kode_fg');
        $sj_kirim = $this->input->post('no_sj');
        $data = array(
            'scan_out' => date('Y-m-d H:i:s'),
            'sj_kirim' => $sj_kirim
        );

        $this->db->where('no_lot', $lot);
        $this->db->update('tb_scan_mutasi', $data);
    }

    public function Laporan_penerimaan_harian()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 42, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('sub_klero/Laporan_penerimaan_harian');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_laporan_penerimaan_harian()
    {
        $tgl = $this->input->get('tgl');
        $data = $this->M_sub_klero->tb_recv_daily($tgl);
        $this->load->view('sub_klero/tb_laporan_penerimaan_harian', ['data' => $data]);
    }
}
