<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Sub_gpc extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }

        $this->load->library('Pdf');
        $this->load->model('M_sql');
        $this->load->model('M_sub_gpc');
        $this->load->model('M_pengaturan');
    }

    public function scan_out()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 38, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('sub_gpc/scan_out');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function cari_kode_kirim()
    {
        $id = $this->input->get('kode');
        $data = $this->db->get_where('tb_scan_out', ['no_lot' => $id]);
        echo $data->num_rows();
    }

    public function cari_kode_kirim1()
    {
        $kode = $this->input->get('kode');
        $hasil = $this->db->query("select count(kode_fg) as kode_fg 
        from tb_fg_gudang 
        where kode_fg = '$kode' and tgl_transfer is not null;")->row_array();
        echo $hasil['kode_fg'];
    }

    public function kode_kirim_simpan()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->session->id_user;
        $kode = $this->input->post('kode_fg');
        $idproduksi = $this->db->get_where('tb_fg_gudang',['kode_fg'=>$kode])->row_array();;
        $data = array(
            'no_lot' => $kode,
            'gudang_asal' => '2',
            'gudang_tujuan' => '1',
            'id_user' => $id,
            'id_produksi' => $idproduksi['id_produksi'],
            'scan_time' => date('Y-m-d H:i:s')
        );
        $this->db->insert('tb_scan_out', $data);
    }

    public function tb_scan_out_daily()
    {
        $tgl = $this->input->get('tgl');
        $data = $this->M_sub_gpc->tb_scan_out($tgl);
        $this->load->view('sub_gpc/tb_scan_out_daily', ['data' => $data]);
    }

    public function scan_in()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 46, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('sub_gpc/scan_in');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function cari_kode_terima()
    {
        $id = $this->input->get('kode');
        $data = $this->db->get_where('tb_scan_mutasi', ['no_lot' => $id]);
        echo $data->num_rows();
    }

    public function simpan_penerimaan()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->session->id_user;
        $kode = $this->input->post('kode_fg');
        $idproduksi = $this->db->get_where('tb_fg_gudang', ['kode_fg' => $kode])->row_array();;
        $data = array(
            'no_lot' => $kode,
            'gudang_asal' => '2',
            'gudang_tujuan' => '0',
            'sj_terima' => $idproduksi['no_sj'],
            'id_user' => $id,
            'id_produksi' => $idproduksi['id_produksi'],
            'scan_time' => date('Y-m-d H:i:s'),
            'sts_lot' => 1
        );
        $this->db->insert('tb_scan_mutasi', $data);
    }

    public function tb_scan_in_daily()
    {
        $tgl = $this->input->get('tgl');
        $data = $this->M_sub_gpc->tb_scan_in($tgl);
        $this->load->view('sub_gpc/tb_scan_in_daily', ['data' => $data]);
    }

    public function cari_kode1()
    {
        $id = $this->input->get('kode');
        $data = $this->db->get_where('tb_fg_gudang', ['kode_fg' => $id]);
        echo $data->num_rows();
    }

    public function cari_kode2()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->input->get('kode');
        $data = $this->db->get_where('tb_mutasi', ['no_lot' => $id, 'id_gudang' => 2, 'DATE(scan_time)' => date('Y-m-d'), 'sts_tr' => 'I']);
        echo $data->num_rows();
    }

    public function simpan_scan_in()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->session->id_user;
        $doctf = $this->input->post('doctf');
        $nosj = $this->input->post('nosj');
        $kode = $this->input->post('kode_fg');
        $idproduksi = $this->db->get_where('tb_fg_gudang', ['kode_fg' => $kode])->row_array();;
        $data = [
            'no_lot' => $kode,
            'id_produksi' => $idproduksi['id_produksi'],
            'id_gudang' => 2,
            'scan_time' => date('Y-m-d H:i:s'),
            'doc_tf' => $doctf,
            'no_sj' => $nosj,
            'crid' => $id,
            'sts_tr' => 'I'
        ];
        $this->db->insert('tb_mutasi', $data);

        $dataupdate = [
            'id_gudang' => '2',
            'tgl_diterima' => date('Y-m-d H:i:s'),
            'tgl_kirim' => NULL
        ];

        $this->db->where('kode_fg', $kode);
        $this->db->update('tb_fg_gudang', $dataupdate);
    }

    public function kirim_brg()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 7, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr, "akses" => $akses]);
        if (isset($akses['id'])) {
            $this->load->view('sub_gpc/kirim_brg');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function get_gudang()
    {
        $gudang = $this->db->get('tb_gudang')->result_array();
        echo '<select class="form-control form-control-sm" name="gudang" id="gudang">';
        foreach ($gudang as $g) {
            echo "<option value=" . $g['id_gudang'] . ">" . $g['gudang'] . "</option>";
        }
        echo '</select>';
    }


    public function tb_pengiriman()
    {
        $data = $this->M_sub_gpc->stok_gempol();
        $this->load->view('sub_gpc/tb_pengiriman', [
            'data' => $data
        ]);
    }

    public function get_kendaraan()
    {
        $kendaraan = $this->db->get_where('tb_kendaraan', ['lokasi' => 'GP'])->result_array();
        echo '<select class="form-control form-control-sm" name="nama_sopir" id="nama_sopir">';
        foreach ($kendaraan as $k) {
            echo "<option value='" . $k['id_kendaraan'] . "'>" . $k['no_pol'] . "</option>";
        }
        echo '</select>';
    }

    public function get_sopir()
    {
        $sopir = $this->M_sub_gpc->get_sopir();
        echo '<select class="form-control form-control-sm" name="nama_sopir" id="nama_sopir">';
        foreach ($sopir as $s) {
            echo "<option value='" . $s['emp_id'] . "'>" . $s['sopir'] . "</option>";
        }
        echo '</select>';
    }

}
