<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Scan extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }

        $this->load->model('M_pengaturan');
        $this->load->model('M_gudang');
    }


    public function penerimaan()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 18, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('scan/scan_penerimaan');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function pengiriman()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 21, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $kota = $this->db->get('tb_kota')->result_array();
        $kendaraan = $this->db->get('tb_kendaraan')->result_array();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('scan/scan_pengiriman2', ['kota' => $kota, 'kendaraan' => $kendaraan]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

public function tb_do()
    {
        $s = $this->input->get("s");
        $e = $this->input->get("e");
        $data = $this->M_gudang->tb_do($s, $e);
        $this->load->view('scan/tb_do', ['data' => $data]);
    }

    public function simpan_do()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->session->id_user;
        $no_pol = $this->input->post('no_pol');
        $sopir = $this->input->post('sopir');
        $km_pergi = $this->input->post('km_pergi');
        $tgl_pergi = $this->input->post('tgl_pergi');
        $keterangan = $this->input->post('keterangan');
        $data = array(
            'id_kendaraan' => $no_pol,
            'id_sopir' => $sopir,
            'km_pergi' => $km_pergi,
            'tgl_pergi' => $tgl_pergi,
            'keterangan' => $keterangan,
            'cr_id' => $id,
            'cr_date' => date('Y-m-d H:i:s'),
            'sts_pengiriman' => 0,
            'unit'=>'KM'
        );
        $this->db->insert('tb_ritase', $data);
    }

    public function hapus_sj()
    {
        $id = $this->input->post('id');
        $this->M_gudang->hapus_sj_all($id);
        $this->db->delete('tb_ritase', ['id_rit' => $id]);
        $this->db->delete('tb_sj', ['id_rit' => $id]);
    }

    public function rit_balik()
    {
        $id_rit = $this->input->post('id_rit');
        $tgl_kembali = $this->input->post('tgl_kembali');
        $km_kembali = $this->input->post('km_kembali');
        $data = array(
            'tgl_kembali' => $tgl_kembali,
            'km_kembali' => $km_kembali
        );

        $this->db->where('id_rit', $id_rit);
        $this->db->update('tb_ritase', $data);
    }

    public function update_pengiriman()
    {
        $id_rit = $this->input->post('id_rit');
        $no_pol = $this->input->post('no_pol');
        $sopir = $this->input->post('sopir');
        $tgl_pergi = $this->input->post('tgl_pergi');
        $km_pergi = $this->input->post('km_pergi');
        $keterangan = $this->input->post('keterangan');

        if ($no_pol <> 0) {
            $data = array(
                'id_kendaraan' => $no_pol
            );
            $this->db->where('id_rit', $id_rit);
            $this->db->update('tb_ritase', $data);
        }

        if ($sopir <> '0') {
            $data = array(
                'id_sopir' => $sopir
            );
            $this->db->where('id_rit', $id_rit);
            $this->db->update('tb_ritase', $data);
        }


        $data = array(
            'tgl_pergi' => $tgl_pergi,
            'km_pergi' => $km_pergi,
            'keterangan' => $keterangan
        );

        $this->db->where('id_rit', $id_rit);
        $this->db->update('tb_ritase', $data);
    }

    public function available_truck()
    {
        $kendaraan = $this->M_gudang->available_truck();
        echo "<option value='0'>--Pilih Kendaraan--</option>";
        foreach ($kendaraan as $k) {
            echo "<option value='" . $k['id_kendaraan'] . "'>" . $k['no_pol'] . "</option>";
        }
    }

    public function available_driver()
    {
        $sopir = $this->M_gudang->available_driver();
        echo "<option value='0'>--Pilih Sopir--</option>";
        foreach ($sopir as $s) {
            echo "<option value='" . $s['emp_id'] . "'>" . $s['FullName'] . "</option>";
        }
    }

    public function scan_kirim()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 26, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('scan/scan_kirim');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_scan_kirim()
    {
        $data = $this->M_gudang->loading_kirim();
        $this->load->view('scan/tb_scan_kirim', ['data' => $data]);
    }

    public function kirim_customer()
    {
        $id = $this->input->post('id');
        $data = array(
            'sts_pengiriman' => 1
        );

        $this->db->where('id_rit', $id);
        $this->db->update('tb_ritase', $data);
    }

    public function simpan_sj()
    {
        $id_rit_sj = $this->input->post('id_rit_sj');
        $no_sj = $this->input->post('no_sj');
        $customer = $this->input->post('customer');
        $kota = $this->input->post('kota');
        $dklk = $this->input->post('dklk');
        $ket_sj = $this->input->post('ket_sj');
        $data = array(
            'id_rit' => $id_rit_sj,
            'no_sj' => $no_sj,
            'id_customer' => $customer,
            'kota' => $kota,
            'dk_lk' => $dklk,
            'keterangan' => $ket_sj
        );

        $this->db->insert('tb_sj', $data);
    }

    public function update_sj()
    {
        $doc_sj = $this->input->post('doc_sj');
        $no_sj = $this->input->post('no_sj');
        $customer = $this->input->post('customer');
        $kota = $this->input->post('kota');
        $dklk = $this->input->post('dklk');
        $ket_sj = $this->input->post('ket_sj');
        $data = array(
            'no_sj' => $no_sj,
            'id_customer' => $customer,
            'kota' => $kota,
            'dk_lk' => $dklk,
            'keterangan' => $ket_sj
        );

        $this->db->where('doc_sj', $doc_sj);
        $this->db->update('tb_sj', $data);
    }

    public function hapus_surat_jalan()
    {
        $id = $this->input->post('id');
        $this->db->delete('tb_sj', ['doc_sj' => $id]);
        $data = array(
            'no_sj' => NULL,
            'tgl_kirim' => NULL,
            'id_kendaraan' => NULL
        );

        $this->db->where('no_sj', $id);
        $this->db->update('tb_fg_gudang', $data);
    }

    public function tb_do_detail()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $sopir = $this->input->get('d');
        $kendaraan = $this->input->get('k');
        $data = $this->M_gudang->tb_do_detail($s, $e, $sopir, $kendaraan);
        $this->load->view('scan/tb_do_detail', ['data' => $data]);
    }
    
    public function cari_retur()
    {
        $kode_lot = $this->input->get('kd');
        $cari1 = $this->db->get_where('tb_fg_gudang', ['kode_fg' => $kode_lot]);
        $cari2 = $this->db->get_where('tb_fg_gudang', ['kode_fg' => $kode_lot, 'dt_retur' => NULL]);
        if ($cari1->num_rows() > 0) {
            echo "1";
        }

        if ($cari1->num_rows() == 0) {
            echo "0";
        }
    }
    
    public function scan_audit()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 22, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('scan/audit');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function cari_lot_gudang()
    {
        $lot = $this->input->get('id');
        $data = $this->db->get_where('tb_fg_gudang', ['kode_fg' => $lot]);
        echo $data->num_rows();
    }

    public function cari_lot_audit()
    {
        $lot = $this->input->get('id');
        $data = $this->db->get_where('tb_audit', ['no_lot' => $lot]);
        echo $data->num_rows();
    }

    public function simpan_audit()
    {
        date_default_timezone_set('Asia/Jakarta');
        $lot = $this->input->post('id');
        $data = array(
            'no_lot' => $lot,
            'scan_time' => date('Y-m-d H:i:s')
        );
        $this->db->insert('tb_audit', $data);
    }
    
    public function cari_sku_opname()
    {
        $lot = $this->input->get('id');
        $data = $this->M_gudang->cari_sku_opname($lot);
        if (isset($data['sku'])) {
            echo '<button type="button" class="btn btn-primary mb-2">
                ' . $data['sku'] . ' - ' . $data['barang'] . ' <span class="badge bg-white text-primary">' . $data['hitung'] . '</span>
            </button>';
        }
    }
    
    // 11 okt 2024
    
    public function cancel_loading()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 24, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('scan/cancel_load');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function cancel_loading_report()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 25, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $usr = $this->M_pengaturan->tb_akses($id);

        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr, "akses" => $akses]);
        if (isset($akses['id'])) {
            $this->load->view('scan/cancel_loading_report');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_cancel_loading_report()
    {
        $mulai = $this->input->get('s');
        $hingga = $this->input->get('e');
        $data = $this->M_gudang->cancel_report($mulai, $hingga);
        $this->load->view('scan/tb_cancel_loading_report', ['data' => $data]);
    }

    public function tb_cancel_loading_report_xls()
    {
        $mulai = $this->input->get('s');
        $hingga = $this->input->get('e');
        $data = $this->M_gudang->cancel_report($mulai, $hingga);
        $this->load->view('scan/tb_cancel_loading_report_xls', ['data' => $data]);
    }

    public function cari_kode_cancel()
    {
        $kode = $this->input->post('id');
        $lot = $this->M_gudang->cancel_load($kode);
        echo $lot['kode_fg'];
    }

    public function load_cancel()
    {
        $kode = $this->input->post('id');
        $data = array(
            'no_sj' => NULL,
            'tgl_kirim' => NULL,
            'id_kendaraan' => NULL
        );

        $this->db->where('kode_fg', $kode);
        $this->db->update('tb_fg_gudang', $data);
    }

    public function cancel_load()
    {
        $kode = $this->input->post('id');
        $this->M_gudang->cancel_loading($kode);
    }
    
    public function hapus_fg_pengiriman()
    {
        $sku = $this->input->post('sku');
        $sj = $this->input->post('sj');
        $data = array(
            'no_sj' => NULL,
            'tgl_kirim' => NULL,
            'id_kendaraan' => NULL
        );

        $this->db->where('sku', $sku);
        $this->db->where('no_sj', $sj);
        $this->db->update('tb_fg_gudang', $data);
    }
    
    public function get_available_sj()
    {
        $sj = $this->input->get('sj');
        $data = $this->M_gudang->get_available_sj($sj);
        foreach ($data as $dt) {
            echo "<option value='" . $dt['doc_sj'] . "'>" . $dt['no_sj'] . "</option>";
        }
    }

    public function pindah_fg_pengiriman()
    {
        $sku = $this->input->post('sku');
        $sj = $this->input->post('sj');
        $pindah_sj = $this->input->post('pindah_sj');
        $data = array(
            'no_sj' => $pindah_sj
        );

        $this->db->where('sku', $sku);
        $this->db->where('no_sj', $sj);
        $this->db->update('tb_fg_gudang', $data);
    }
    
    public function simpan_expedisi()
    {
        $no_pol = $this->input->post('no_pol');
        $no_resi = $this->input->post('no_resi');
        $customer = $this->input->post('customer');
        $ket_sj = $this->input->post('ket_sj');
        $tgl = $this->input->post('tgl');
        $data = array(
            'no_pol' => $no_pol,
            'no_resi' => $no_resi,
            'customer' => $customer,
            'keterangan' => $ket_sj,
            'tgl_pergi' => $tgl,
            'sts_pengiriman' => 0,
	    'unit'=>'KM'
        );
        $this->db->insert('tb_ritase', $data);
    }

    public function tb_expedisi()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $exp = $this->M_gudang->tb_expedisi($s, $e);
        $this->load->view('scan/tb_exp', ['exp' => $exp]);
    }

    public function cari_cancel_lot()
    {
        $kode = $this->input->post('id');
        $lot = $this->M_gudang->cancel_no_lot($kode);
        echo $lot['no_lot'];
    }

    public function cari_cancel_kirim()
    {
        $kode = $this->input->post('id');
        $lot = $this->M_gudang->cancel_no_lot_kirim($kode);
        echo $lot['id_rit'];
    }

    public function simpan_sj_exp()
    {
        $id_rit_sj = $this->input->post('id_rit_sj');
        $no_sj = $this->input->post('no_sj');
        $ket_sj = $this->input->post('ket_sj');
        $data = array(
            'id_rit' => $id_rit_sj,
            'no_sj' => $no_sj,
            'keterangan' => $ket_sj
        );

        $this->db->insert('tb_sj', $data);
    }

    public function update_sj_exp()
    {
        $doc_sj = $this->input->post('doc_sj');
        $no_sj = $this->input->post('no_sj');
        $ket_sj = $this->input->post('ket_sj');
        $data = array(
            'no_sj' => $no_sj,
            'keterangan' => $ket_sj
        );

        $this->db->where('doc_sj', $doc_sj);
        $this->db->update('tb_sj', $data);
    }

    public function update_exp()
    {
        $id = $this->input->post('id');
        $nopol = $this->input->post('nopol');
        $tgl = $this->input->post('tgl');
        $resi = $this->input->post('resi');
        $cust = $this->input->post('cust');
        $ket = $this->input->post('ke');
        $data = array(
            'no_pol' => $nopol,
            'tgl_pergi' => $tgl,
            'no_resi' => $resi,
            'customer' => $cust,
            'keterangan' => $ket
        );

        $this->db->where('id_rit', $id);
        $this->db->update('tb_ritase', $data);
    }

    public function scan_lot()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 32, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('scan/scan_lot');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function cari_lot_info()
    {
        $kode = $this->input->get('kd');
        $data = $this->db->get_where('tb_fg_gudang', ['kode_fg' => $kode]);
        echo $data->num_rows();
    }

    public function tb_scan_lot()
    {
        $kode = $this->input->get('kd');
        $data = $this->M_gudang->scan_lot($kode);
        $this->load->view('scan/tb_scan_lot', ['data' => $data]);
    }

    public function stock_opname()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 33, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('scan/stock_opname');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_stock_opname()
    {
        $data = $this->M_gudang->tb_stock_opname();
        $this->load->view('scan/tb_stock_opname', ['data' => $data]);
    }

    public function tb_stock_opname_xls()
    {
        $data = $this->M_gudang->tb_stock_opname();
        $this->load->view('scan/tb_stock_opname_xls', ['data' => $data]);
    }

    public function mutasi_sj()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 27, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $usr = $this->M_pengaturan->tb_akses($id);
        $sj = $this->M_gudang->get_sj_available();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr, "akses" => $akses]);
        if (isset($akses['id'])) {
            $this->load->view('scan/mutasi_sj', ["sj" => $sj]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function get_sj()
    {
        $sj = $this->input->get('sj');
        $data = $this->M_gudang->get_available_sj($sj);
        echo "<option value='0'>-Pilih SJ tujuan-</option>";
        foreach ($data as $d) {
            echo "<option value='" . $d['doc_sj'] . "'>" . $d['no_sj'] . "</option>";
        }
    }

    public function tb_scan_pindah_sj()
    {
        $sj = $this->input->get('sj');
        $data = $this->M_gudang->sj_tujuan($sj);
        $this->load->view('scan/tb_scan_pindah_sj', ['data' => $data]);
    }

    public function cari_kode_sj()
    {
        $kode = $this->input->get('kode');
        $sj = $this->input->get('sj');
        $data = $this->M_gudang->cari_kode_sj($kode, $sj);
        echo $data['cari'];
    }
}
