<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Qc extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }

        $this->load->model('M_qc');
        $this->load->model('M_pengaturan');
    }

    public function cari_retur()
    {
        $kode_lot = $this->input->get('kd');
        $cari = $this->M_qc->cari_retur($kode_lot);
        echo $cari['cari'];
    }

    public function cari_retur_lot()
    {
        $kode_lot = $this->input->get('kd');
        $cari = $this->M_qc->cari_retur_lot($kode_lot);
        echo $cari['no_lot'];
    }

    public function retur()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 29, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('qc/retur');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_retur()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $head = $this->M_qc->tb_retur($s, $e);
        $this->load->view('qc/tbretur', ['head' => $head]);
    }

    public function simpan_retur()
    {
        $no_pol = $this->input->post('no_pol');
        $no_sj = $this->input->post('no_sj');
        $tgl = $this->input->post('tgl');
        $cust = $this->input->post('cust');
        $ket = $this->input->post('ket');
        $id = $this->session->id_user;
        $data = array(
            'no_pol' => $no_pol,
            'no_sj_retur' => $no_sj,
            'tgl' => $tgl,
            'id_customer' => $cust,
            'keterangan' => $ket,
            'id_retur' => 0,
            'cr_id' => $id
        );
        $this->db->insert('tb_retur_head', $data);
    }

    public function update_retur()
    {
        $id = $this->input->post('id');
        $nopol = $this->input->post('nopol');
        $sj = $this->input->post('sj');
        $tgl = $this->input->post('tgl');
        $cust = $this->input->post('cust');
        $ket = $this->input->post('ket');

        $data = array(
            'no_pol' => $nopol,
            'no_sj_retur' => $sj,
            'tgl' => $tgl,
            'id_customer' => $cust,
            'keterangan' => $ket
        );

        $this->db->where('id_retur', $id);
        $this->db->update('tb_retur_head', $data);
    }

    public function delete_retur()
    {
        $id = $this->input->post('id');
        $this->db->delete('tb_retur_head', ['id_retur' => $id]);
        $this->db->delete('tb_retur', ['id_retur' => $id]);
    }

    public function scan_retur()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 29, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('qc/scan_retur');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_scan_retur()
    {
        $data = $this->M_qc->tb_scan_retur();
        $this->load->view('qc/tb_scan_retur', ['data' => $data]);
    }

    public function simpan_kode_retur()
    {
        $id = $this->input->post('id');
        $kode = $this->input->post('kode_fg');
        $sts = $this->input->post('sts');
        $this->db->query("call retur_lot('$kode','$id',$sts);");
        // hapus info awal
        $data = array(
            'id_kendaraan' => NULL,
            'no_sj' => NULL,
            'tgl_kirim' => NULL,
            'doc_tf' => NULL
        );
        $this->db->where('kode_fg', $kode);
        $this->db->update('tb_fg_gudang', $data);
    }

    public function cek_renumber()
    {
        $id = $this->input->get('id');
        $data = $this->M_qc->cek_renumber($id);
    }

    public function renumber_lot()
    {
        $id = $this->input->post('id');
        $sku = $this->input->post('sku');
        $bj = $this->input->post('bj');
        $rusak = $this->input->post('rusak');
        $this->db->query("call renumber_lot($id,'$sku',$bj,$rusak);");
    }

    public function tb_detail_lot_retur()
    {
        $id = $this->input->get('id');
        $sku = $this->input->get('sku');
        $data = $this->M_qc->tb_detail_retur($id, $sku);
        $this->load->view('qc/tb_detail_lot_retur', ['data' => $data]);
    }

    public function retur_selesai()
    {
        $id = $this->input->post('id');
        $data = array(
            'sts' => 1
        );

        $this->db->where('id_retur', $id);
        $this->db->update('tb_retur_head', $data);
    }

    public function scan_retur_kirim()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 32, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('qc/scan_retur_kirim');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function cari_retur_kirim()
    {
        $id = $this->input->get('kd');
        $data = $this->M_qc->kode_lot_kirim($id);
        echo $data['cari'];
    }

    public function kirim_kode_retur()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->input->post('kode_fg');
        $data = array(
            'tgl_kirim' => date('Y-m-d H:i:s')
        );

        $this->db->where('no_lot', $id);
        $this->db->update('tb_retur', $data);
    }

    public function tb_kirim_retur()
    {
        $data = $this->M_qc->tb_kirim_retur();
        $this->load->view('qc/tb_kirim_retur', ['data' => $data]);
    }

    public function simpan_scrap()
    {
        $id = $this->input->post('id_scrap');
        $keterangan = $this->input->post('keterangan');
        $data = array(
            'sts_retur' => 3,
            'keterangan' => $keterangan
        );

        $this->db->where('id_retur_det', $id);
        $this->db->update('tb_retur', $data);
    }

    public function kirim_gudang()
    {
        $id = $this->input->post('id');
        $data = array(
            'sts_retur' => 2
        );
        $this->db->where('id_retur_det', $id);
        $this->db->update('tb_retur', $data);
    }
}
