<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Purchase extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }

        $this->load->model('M_pengaturan');
        $this->load->model('M_purchase');
    }


    public function index()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 20, "akses" => 1, "id_user" => $id])->row_array();

        $datapurch = $this->M_purchase->tb_pr();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->db->get('tb_sub_menu')->result_array();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        $unit = $this->db->get("tb_unit")->result_array();
        if (isset($akses['id'])) {
            $this->load->view('purchase/purchase', ["data" => $datapurch, "unit" => $unit, "akses" => $akses]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function dtl_purch()
    {
        $kd = $this->input->get('kd');
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 1, "akses" => 1, "id_user" => $id])->row_array();

        $datapurch = $this->M_purchase->tb_pr_dtl($kd);

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->db->get('tb_sub_menu')->result_array();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        $unit = $this->db->get("tb_unit")->result_array();
        if (isset($akses['id'])) {
            $this->load->view('purchase/purchase_dtl', ["data" => $datapurch, "unit" => $unit, "akses" => $akses, "kd" => $kd]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function purch_approve()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->session->id_user;
        $kd = $this->input->post('kd'); //nomor LPBJ
        $sts = $this->input->post('nmr');
        $brg = $this->input->post('kd_brg');
        $qty = $this->input->post('qty');
        $keterangan = $this->input->post('keterangan');
        $jml = count($sts);
        $data = array(
            'sts_purchase' => 0
        );
        $this->db->update('tb_pr', $data, ['kd_lpbj' => $kd]);
        for ($no = 0; $no < $jml; $no++) {
            $data = array(
                'id_purchasing' => $id,
                'sts_purchase' => $sts[$no],
                'dt_purch' => date('Y-m-d H:i:s'),
                'keterangan_purchase' => $keterangan[$no],
                'qty_req_pr' => $qty[$no]
            );
            $this->db->update('tb_pr', $data, ['kd_lpbj' => $kd, 'doc_id' => $brg[$no]]);

            $data = array(
                'qty_req' => $qty[$no]
            );
            $this->db->update('lpbj_d', $data, ['kd_lpbj' => $kd, 'doc_id' => $brg[$no]]);
        }
    }

    public function tanggal()
    {
        date_default_timezone_set('Asia/Jakarta'); // Ubah sesuai dengan zona waktu Anda
        echo date('Y-m-d H:i:s');
    }
}
