<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Produksi extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }

        $this->load->library('Pdf');
        $this->load->model('M_sql');
        $this->load->model('M_Produksi');
        $this->load->model('M_pengaturan');
    }

    public function lotfg()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 7, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->db->get('tb_sub_menu')->result_array();
        $usr = $this->M_pengaturan->tb_akses($id);
        $mesin = $this->db->get("tb_mesin")->result_array();
        $fg = $this->db->get("tb_fg")->result_array();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr, "akses" => $akses]);
        if (isset($akses['id'])) {
            $this->load->view('produksi-lotfg', ["mesin" => $mesin, "fg" => $fg]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_lotfg()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 7, "akses" => 1, "id_user" => $id])->row_array();
        $mulai = $this->input->get('mulai');
        $hingga = $this->input->get('hingga');
        $datalotfg = $this->M_Produksi->tb_lotfg($mulai, $hingga);
        $brg = $this->db->get("tb_fg")->result_array();
        $mesin = $this->db->get("tb_mesin")->result_array();
        $this->load->view('produksi-tblotfg', ["resultlot" => $datalotfg, "brglot" => $brg, "resultmesin" => $mesin, "akses" => $akses]);
    }

    public function tb_lotfg_xls()
    {
        $mulai = $this->input->get('mulai');
        $hingga = $this->input->get('hingga');

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        $datalotfg = $this->M_Produksi->tb_lotfg($mulai, $hingga);
        $brg = $this->db->get("tb_fg")->result_array();
        $mesin = $this->db->get("tb_mesin")->result_array();

        $i = 2;
        $no = 1;
        $sheet->setCellValue('A1', 'No.');
        $sheet->setCellValue('B1', 'SKU');
        $sheet->setCellValue('C1', 'Nama Barang');
        $sheet->setCellValue('D1', 'Tgl');
        $sheet->setCellValue('E1', 'Shift');
        $sheet->setCellValue('F1', 'No Mesin');
        $sheet->setCellValue('G1', 'Jumlah Kardus');
        $sheet->setCellValue('H1', 'Tgl Transfer');
        foreach ($datalotfg as $l) {
            $sheet->setCellValue('A' . $i, $no++);
            $sheet->setCellValue('B' . $i, $l['sku']);
            $sheet->setCellValue('C' . $i, $l['barang']);
            $sheet->setCellValue('D' . $i, $l['tanggal']);
            $sheet->setCellValue('E' . $i, $l['shift']);
            $sheet->setCellValue('F' . $i, $l['mesin']);
            $sheet->setCellValue('G' . $i, $l['nomor']);
            $sheet->setCellValue('H' . $i, $l['tgl_transfer']);
            $i++;
        }
        $styleArray = [
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],
        ];
        $i = $i - 1;
        $sheet->getStyle('A1:H' . $i)->applyFromArray($styleArray);

        $writer = new Xlsx($spreadsheet);
        $filename = 'Laporan_LOT_FG.xlsx';

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output'); // Unduh file ke browser
        exit;
    }

    public function cetaklotfg()
    {
        $id = $this->input->get('id');
        $datalot = $this->M_Produksi->cetaklot($id);

        $leftMargin = 1;
        $topMargin = 1;
        $rightMargin = 1;
        $bottomMargin = 1;
        $custom_format = array(100, 80); // Landscape: lebar 100mm, tinggi 80mm
        // Inisialisasi TCPDF
        $pdf = new TCPDF('L', 'mm', $custom_format, true, 'UTF-8', false); // 'L' untuk landscape
        $pdf->SetMargins($leftMargin, $topMargin, $rightMargin);
        $pdf->SetAutoPageBreak(false, $bottomMargin);
        $pdf->AddPage();

        $style = array(
            'position' => '',
            'align' => '',
            'stretch' => true,
            'fitwidth' => false,
            'cellfitalign' => '',
            'border' => true,
            'hpadding' => 'auto',
            'vpadding' => 'auto',
            'fgcolor' => array(0, 0, 0),
            'bgcolor' => array(255, 255, 255),
            'text' => true,
            'font' => 'helvetica',
            'fontsize' => 20,
            'stretchtext' => 4
        );

        // Lebar dan tinggi yang tersedia setelah margin
        $available_width = 100 - ($leftMargin + $rightMargin);  // 100 mm - 2 mm
        $available_height_per_barcode = (80 - ($topMargin + $bottomMargin)) / 2;  // 80 mm - 2 mm, dibagi 2

        // Perulangan untuk data yang dihasilkan, memastikan dua barcode per halaman
        foreach ($datalot as $index => $d) {
            if ($index % 2 == 0 && $index > 0) {
                $pdf->AddPage(); // Tambah halaman baru setelah dua barcode        
            }

            $yPosition = $index % 2 == 0 ? $topMargin : $topMargin + $available_height_per_barcode;

            // Menulis barcode
            $pdf->write1DBarcode($d['lotfg'], 'C128', $leftMargin, $yPosition, $available_width, $available_height_per_barcode - 5, 0.6, $style, 'N');

            // Menulis warna di bawah barcode
            $pdf->SetXY($leftMargin, $yPosition + $available_height_per_barcode - 5);
            $pdf->Cell($available_width, 5, $d['warna'], 1, 1, 'C');
        }

        $pdf->Output('lotnumber.pdf', 'I');
    }

    public function simpanlotfg()
    {
        $brglot = $this->input->post('brglot');
        $tgllot = $this->input->post('tgllot');
        $shiftlot = $this->input->post('shiftlot');
        $mesinlot = $this->input->post('mesinlot');
        $qtylot = $this->input->post('qtylot');
        $data = array(
            'shift' => $shiftlot,
            'tgl' => $tgllot,
            'kd_mesin' => $mesinlot,
            'nomor' => $qtylot,
            'sku' => $brglot
        );
        $this->db->insert('tb_lot', $data);
    }

    public function tfgudang()
    {
        //$fg = $this->input->post('id');
        //$this->db->query("call tf_gudang(" . $fg . ");");
        $fg = $this->input->post('id');
        $tfid = $this->input->post('tfid');
        $this->db->query("call tf_gudang(" . $fg . ",'" . $tfid . "');");
    }

    public function update_lot()
    {
        $id = $this->input->post('id');
        $sku = $this->input->post('sku');
        $sift = $this->input->post('sift');
        $mesin = $this->input->post('mesin');

        $data = array(
            'shift' => $sift,
            'sku' => $sku,
            'kd_mesin' => $mesin
        );

        $this->db->where('id', $id);
        $this->db->update('tb_lot', $data);
    }
}
