<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Pengaturan extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }

        $this->load->library('Pdf');
        $this->load->model('M_pengaturan');
    }

    public function usr()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 11, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('usr');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_usr()
    {
        $emp = $this->input->get('key');
        $datauser = $this->M_pengaturan->tb_emp($emp);
        $this->load->view('tb_usr', ["datauser" => $datauser]);
    }

    public function tb_unit_kerja()
    {
        $emp = $this->input->get('emp');
        $unit = $this->M_pengaturan->get_unit($emp);
        $this->load->view('tb_unit_emp', ["unit" => $unit]);
    }

    public function add_unit_kerja()
    {
        $emp = $this->input->post('id_emp');
        $pilihan = $this->input->post('pilihan');
        $jml = count($pilihan);
        for ($no = 0; $no < $jml; $no++) {
            $data = array(
                'emp_id' => $emp,
                'unit' => $pilihan[$no]
            );
            $this->db->insert('tb_emp_unit', $data);
        }
    }

    public function hapus_unit_kerja()
    {
        $unit = $this->input->Post('emp');
        $this->db->delete('tb_emp_unit', ['id_emp_unit' => $unit]);
    }

    public function tb_akses()
    {
        $id = $this->input->get('id');
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->db->get('tb_sub_menu')->result_array();
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('tb_akses', ["grup" => $grup, "sub" => $sub, "usr" => $usr, "id" => $id]);
    }

    public function buka_akses()
    {
        $id = $this->input->get('id');
        $menu = $this->input->get('menu');
        $cari = $this->M_pengaturan->cari_akses($id, $menu);
        if ($cari['cari_akses'] == 0) {
            $data = [
                'id_user' => $id,
                'id_menu' => $menu,
                'akses' => 1
            ];
            $this->db->insert('tb_akses', $data);
        }

        if ($cari['cari_akses'] == 1) {
            $data = ['akses' => 1];
            $filter = ['id_user' => $id, 'id_menu' => $menu];
            $this->db->where($filter);
            $this->db->update('tb_akses', $data);
        }
    }

    public function tutup_akses()
    {
        $id = $this->input->get('id');
        $menu = $this->input->get('menu');
        $cari = $this->M_pengaturan->cari_akses($id, $menu);
        if ($cari['cari_akses'] == 0) {
            $data = [
                'id_user' => $id,
                'id_menu' => $menu,
                'akses' => 0
            ];
            $this->db->insert('tb_akses', $data);
        }

        if ($cari['cari_akses'] == 1) {
            $data = ['akses' => 0];
            $filter = ['id_user' => $id, 'id_menu' => $menu];
            $this->db->where($filter);
            $this->db->update('tb_akses', $data);
        }
    }

    public function buka_dml()
    {
        $id = $this->input->get('id');
        $menu = $this->input->get('menu');
        $cari = $this->M_pengaturan->cari_dml($id, $menu);
        if ($cari['cari_dml'] == 0) {
            $data = [
                'id_user' => $id,
                'id_menu' => $menu,
                'dml' => 1
            ];
            $this->db->insert('tb_akses', $data);
        }

        if ($cari['cari_dml'] == 1) {
            $data = ['dml' => 1];
            $filter = ['id_user' => $id, 'id_menu' => $menu];
            $this->db->where($filter);
            $this->db->update('tb_akses', $data);
        }
    }

    public function tutup_dml()
    {
        $id = $this->input->get('id');
        $menu = $this->input->get('menu');
        $cari = $this->M_pengaturan->cari_dml($id, $menu);
        if ($cari['cari_dml'] == 0) {
            $data = [
                'id_user' => $id,
                'id_menu' => $menu,
                'dml' => 0
            ];
            $this->db->insert('tb_akses', $data);
        }

        if ($cari['cari_dml'] == 1) {
            $data = ['dml' => 0];
            $filter = ['id_user' => $id, 'id_menu' => $menu];
            $this->db->where($filter);
            $this->db->update('tb_akses', $data);
        }
    }

    public function buka_unduh()
    {
        $id = $this->input->get('id');
        $menu = $this->input->get('menu');
        $cari = $this->M_pengaturan->cari_unduh($id, $menu);
        if ($cari['cari_unduh'] == 0) {
            $data = [
                'id_user' => $id,
                'id_menu' => $menu,
                'unduh' => 1
            ];
            $this->db->insert('tb_akses', $data);
        }

        if ($cari['cari_unduh'] == 1) {
            $data = ['unduh' => 1];
            $filter = ['id_user' => $id, 'id_menu' => $menu];
            $this->db->where($filter);
            $this->db->update('tb_akses', $data);
        }
    }

    public function tutup_unduh()
    {
        $id = $this->input->get('id');
        $menu = $this->input->get('menu');
        $cari = $this->M_pengaturan->cari_unduh($id, $menu);
        if ($cari['cari_unduh'] == 0) {
            $data = [
                'id_user' => $id,
                'id_menu' => $menu,
                'unduh' => 0
            ];
            $this->db->insert('tb_akses', $data);
        }

        if ($cari['cari_unduh'] == 1) {
            $data = ['unduh' => 0];
            $filter = ['id_user' => $id, 'id_menu' => $menu];
            $this->db->where($filter);
            $this->db->update('tb_akses', $data);
        }
    }

    public function ipakses()
    {
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->db->get('tb_sub_menu')->result_array();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        $this->load->view('ipakses');
        $this->load->view('footer');
    }

    public function tb_ip()
    {
        $data = $this->M_pengaturan->iplist();
        $this->load->view('tb_ip', ["result" => $data]);
    }

    public function log()
    {
        date_default_timezone_set('Asia/Jakarta');
        $strTable = $this->input->post('strTable');
        $keterangan = $this->input->post('keterangan');
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
	$tpclog = $this->load->database('log', TRUE);
        $user = $this->session->strEmail;
        //$strBuffer = str_replace('"', '`', str_replace("'", "`", $query));
        $data = array(
            'strPCHostname' => gethostbyaddr($ip),
            'strIPv4' => $ip,
            'strPort' => $_SERVER['REMOTE_PORT'],
            'strTable' => $strTable,
            //'strQuery' => $strBuffer,
            'strKeterangan' => 'User ' . $user . ' - ' . $keterangan,
            'dtCreate' => date('Y-m-d H:i:s'),
            'usrCreate' => $user
        );
        //$this->db->insert('tpc_log', $data);
	$tpclog->insert('tpc_log', $data);
    }

    public function simpan_ip()
    {
        $ip = $this->input->post('ip');
        $aplikasi = $this->input->post('aplikasi');
        $jenis = $this->input->post('jenis');
        $sts = $this->input->post('sts');
        $data = array(
            'strIPv4' => $ip,
            'strNmApp' => $aplikasi,
            'stsIP' => $jenis,
            'stsAktif' => $sts
        );

        $this->db->insert('tpc_ip_allow', $data);
    }

    public function hapus_ip()
    {
        $id = $this->input->post('ID');
        $this->db->delete('tpc_ip_allow', array('ID' => $id));
    }
    
    // tpc
    public function ipaksestpc()
    {
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->db->get('tb_sub_menu')->result_array();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        $this->load->view('ipaksestpc');
        $this->load->view('footer');
    }

    public function tb_ip_tpc()
    {
        $data = $this->M_pengaturan->iplisttpc();
        $this->load->view('tb_ip_tpc', ["result" => $data]);
    }

    public function simpan_ip_tpc()
    {
        $ip = $this->input->post('ip');
        $aplikasi = $this->input->post('aplikasi');
        $jenis = $this->input->post('jenis');
        $sts = $this->input->post('sts');
        $tpcdb = $this->load->database('tpc', TRUE);
        $data = array(
            'strIPv4' => $ip,
            'strNmApp' => $aplikasi,
            'stsIP' => $jenis,
            'stsAktif' => $sts
        );
        $tpcdb->insert('tpc_ip_allow', $data);
    }

    public function hapus_ip_tpc()
    {
        $id = $this->input->post('ID');
        $tpcdb = $this->load->database('tpc', TRUE);
        $tpcdb->delete('tpc_ip_allow', array('ID' => $id));
    }

    public function get_approvalline()
    {
        $level = $this->input->get('lvl');
        $data = $this->M_pengaturan->get_approvalline($level);
        foreach ($data as $d) {
            echo "<option value='" . $d['emp_id'] . "'>" . $d['FullName'] . "</option>";
        }
    }

    public function get_id_emp()
    {
        $id = $this->input->get('id');
        $cari = $this->db->get_where('employee', ['emp_id' => $id]);
        echo $cari->num_rows();
    }

    public function get_email_emp()
    {
        $email = $this->input->get('email_emp');
        $cari = $this->db->get_where('employee', ['Email' => $email]);
        echo $cari->num_rows();
    }

    public function add_emp()
    {
        $id_emp = $this->input->post('id_emp');
        $nama_emp = $this->input->post('nama_emp');
        $email_emp = $this->input->post('email_emp');
        $pass_emp = $this->input->post('pass_emp');
        $divisi_emp = $this->input->post('divisi_emp');
        $level_emp = $this->input->post('level_emp');
        $jabatan_emp = $this->input->post('jabatan_emp');
        $aproval_emp = $this->input->post('aproval_emp');
        $data = array(
            'emp_id' => $id_emp,
            'FullName' => $nama_emp,
            'Email' => $email_emp,
            'strPassword' => password_hash($pass_emp, PASSWORD_BCRYPT),
            'Division' => $divisi_emp,
            'Level' => $level_emp,
            'strJobPosition' => $jabatan_emp,
            'ApprovalLine' => $aproval_emp
        );

        $this->db->insert('employee', $data);
    }
}
