<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Masterdata extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }

        $this->load->model('M_masterdata');
        $this->load->model('M_pengaturan');
    }

    public function mesin()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 3, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->db->get('tb_sub_menu')->result_array();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $mesin = $this->db->get('tb_mesin')->result_array();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('master/mesin', ["mesin" => $mesin]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function IP()
    {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        echo $ip;
    }

    public function kendaraan()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 4, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->db->get('tb_sub_menu')->result_array();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('master/kendaraan');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_kendaraan()
    {
        $data = $this->db->get('tb_kendaraan')->result_array();
        $this->load->view('master/tb_kendaraan', ["data" => $data]);
    }

    public function simpan_kendaraan()
    {
        $nopol = $this->input->post('nopol');
        $merk = $this->input->post('merk');
        $jenis = $this->input->post('jenis');
        $kapasitas = $this->input->post('kapasitas');
        $tgl_stnk = $this->input->post('tgl_stnk');
        $data = array(
            'no_pol' => $nopol,
            'merk' => $merk,
            'jenis' => $jenis,
            'cc' => $kapasitas,
            'tgl_stnk' => $tgl_stnk
        );
        $this->db->insert('tb_kendaraan', $data);
        //$Pengaturan->log('tb_kendaraan', 'Telah menambahkan master kendaraan dengan nopol :' . $nopol);
    }

    public function hapus_kendaraan()
    {
        $id = $this->input->post('id');
        $this->db->delete('tb_kendaraan', array('id_kendaraan' => $id));
    }

    public function update_kendaraan()
    {
        $id_kendaraan = $this->input->post('id_kendaraan');
        $no_pol = $this->input->post('no_pol');
        $merk = $this->input->post('merk');
        $jenis = $this->input->post('jenis');
        $cc = $this->input->post('cc');
        $tgl_stnk = $this->input->post('tgl_stnk');
        $data = array(
            'no_pol' => $no_pol,
            'merk' => $merk,
            'jenis' => $jenis,
            'cc' => $cc,
            'tgl_stnk' => $tgl_stnk
        );
        $this->db->where('id_kendaraan', $id_kendaraan);
        $this->db->update('tb_kendaraan', $data);
    }


    public function Item()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 1, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->db->get('tb_sub_menu')->result_array();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        $unit = $tpcdb->get("tb_unit")->result_array();
        if (isset($akses['id'])) {
            $this->load->view('master/brg', ["unit" => $unit, "akses" => $akses]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }


    public function tb_brg()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        $cari = $this->input->get('cari');
        $halaman = $this->input->get('page');
        $items = $this->input->get('items');
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 1, "akses" => 1, "id_user" => $id])->row_array();
        $page = 1;
        $items_per_page = 10;

        if (!empty($halaman)) {
            $page = filter_input(INPUT_GET, 'page', FILTER_VALIDATE_INT);
            if (false === $page) {
                $page = 1;
            }
        }

        if (!empty($items)) {
            $items_per_page = filter_input(INPUT_GET, 'items', FILTER_VALIDATE_INT);
            if (false === $items_per_page) {
                $items_per_page = 10;
            }
        }

        $offset = ($page - 1) * $items_per_page;

        $databrg = $this->M_masterdata->Brg($cari, $offset, $items_per_page);
        $jml = $this->M_masterdata->jmldatabrg($cari);
        $total_halaman = ceil($jml['total'] / $items_per_page);
        $range = 2;
        $start = max(1, $page - $range);
        $end = min($total_halaman, $page + $range);
        $unit = $tpcdb->get("tb_unit")->result_array();
        $this->load->view("master/tb_brg", [
            "result" => $databrg,
            "jml" => $jml,
            "total_halaman" => $total_halaman,
            "cari" => $cari,
            "items_per_page" => $items_per_page,
            "page" => $page,
            "start" => $start,
            "end" => $end,
            "unit" => $unit,
            "akses" => $akses
        ]);
    }

    public function simpan_brg()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        date_default_timezone_set('Asia/Jakarta');
        $kodebrg = $this->input->POST('kodebrg');
        $deskripsibrg = $this->input->POST('deskripsibrg');
        $unit1brg = $this->input->POST('unit1brg');
        $unit2brg = $this->input->POST('unit2brg');
        $ratio2brg = $this->input->POST('ratio2brg');
        $unit3brg = $this->input->POST('unit3brg');
        $ratio3brg = $this->input->POST('ratio3brg');
        $user = $this->session->strEmail;
        $lokasibrg = $this->input->POST('lokasibrg');
        $data = array(
            'kd_brg' => $kodebrg,
            'brg' => $deskripsibrg,
            'uom1' => $unit1brg,
            'uom2' => $unit2brg,
            'uom3' => $unit3brg,
            'ratio2' => $ratio2brg,
            'ratio3' => $ratio3brg,
            'sts' => '1',
            'cr_date' => date('Y-m-d H:i:s'),
            'cr_usr' => $user
        );
        $tpcdb->insert('tb_brg', $data);

        $dataunit = array(
            'kd_brg' => $kodebrg,
            'id_unit' => $lokasibrg
        );
        $tpcdb->insert('tb_brg_unit', $dataunit);
    }


    public function update_brg()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        $edkodebrg = $this->input->POST('edkodebrg');
        $eddeskripsibrg = $this->input->POST('eddeskripsibrg');
        $edunit1brg = $this->input->POST('edunit1brg');
        $edunit2brg = $this->input->POST('edunit2brg');
        $edratio2brg = $this->input->POST('edratio2brg');
        $edunit3brg = $this->input->POST('edunit3brg');
        $edratio3brg = $this->input->POST('edratio3brg');


        $data = array(
            'brg' => $eddeskripsibrg,
            'uom1' => $edunit1brg,
            'uom2' => $edunit2brg,
            'uom3' => $edunit3brg,
            'ratio2' => $edratio2brg,
            'ratio3' => $edratio3brg
        );

        $tpcdb->where('kd_brg', $edkodebrg);
        $tpcdb->update('tb_brg', $data);
    }

    public function hapus_brg()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        $ID = $this->input->post('kode');
        $tpcdb->delete('tb_brg', ['kd_brg' => $ID]);
        $tpcdb->delete('tb_brg_unit', ['kd_brg' => $ID]);
    }

    public function unduhbrg()
    {
        $cari = $this->input->get('cari');
        $data = $this->M_masterdata->unduh($cari);
        $this->load->view('master/item_list', ["result" => $data]);
    }

    public function tb_unit()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        $kd = $this->input->get('kd');
        $data_unit = $this->M_masterdata->tb_unit($kd);
        echo "<table class='table table-sm'>";
        echo "<thead>";
        echo "<th colspan='2'>Unit</th>";
        echo "</thead>";
        echo "<tbody>";
        foreach ($data_unit as $d_u) {
            echo "<tr>";
            echo "<td>" . $d_u['unit'] . "</td>";
            echo "<td><input type='checkbox' name='pilihan[]' id='pilihan[]' value='" . $d_u['unit'] . "'></td>";
            echo "</tr>";
        }
        echo "</tbody>";
        echo "</table>";
    }

    public function add_unit()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        $kd = $this->input->post('kd_brg');
        $pilihan = $this->input->post('pilihan');
        $jml = count($pilihan);
        for ($no = 0; $no < $jml; $no++) {
            $data = array(
                'kd_brg' => $kd,
                'id_unit' => $pilihan[$no]
            );
            $tpcdb->insert('tb_brg_unit', $data);
        }
    }

    public function hapus_unit()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        $kd = $this->input->post('kd');
        $unit = $this->input->post('unit');
        $tpcdb->delete('tb_brg_unit', ['kd_brg' => $kd, 'id_unit' => $unit]);
    }
    
    public function emp()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 2, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->db->get('tb_sub_menu')->result_array();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('master/employee');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_emp()
    {
        $this->db->order_by('emp_id', 'ASC');
        $dir = $this->db->get_where('employee', ['Level' => 1])->result_array();
        $this->load->view('master/tb_emp', ['dir' => $dir]);
    }

    public function simpan_emp()
    {
        $id_atasan = $this->input->post('id_atasan');
        $id_emp = $this->input->post('id_emp');
        $nama_emp = $this->input->post('nama_emp');
        $email_emp = $this->input->post('email_emp');
        $pass_emp = password_hash($this->input->post('pass_emp'), PASSWORD_BCRYPT);
        $divisi_emp = $this->input->post('divisi_emp');
        $level_emp = $this->input->post('level_emp');
        $jabatan_emp = $this->input->post('jabatan_emp');
        $data = array(
            'ApprovalLine' => $id_atasan,
            'emp_id' => $id_emp,
            'FullName' => $nama_emp,
            'Email' => $email_emp,
            'strPassword' => $pass_emp,
            'Division' => $divisi_emp,
            'Level' => $level_emp,
            'strJobPosition' => $jabatan_emp
        );

        $this->db->insert('employee', $data);
    }

    public function disable_user()
    {
        $id = $this->input->post('id');
        $data = array(
            'stsAktif' => '0'
        );

        $this->db->where('emp_id', $id);
        $this->db->update('employee', $data);
    }

    public function get_apprv()
    {
        $lvl = $this->input->get('lvl');
        $bos = $this->input->get('bos');
        $apprv = $this->M_masterdata->get_apprv($lvl);
        foreach ($apprv as $a) {
            if ($a['emp_id'] == $bos) {
                echo "<option value='" . $a['emp_id'] . "' selected>" . $a['lvl'] . " - " . $a['Fullname'] . "</option>";
            } else {
                echo "<option value='" . $a['emp_id'] . "'>" . $a['lvl'] . " - " . $a['Fullname'] . "</option>";
            }
        }
    }

    public function update_emp()
    {
        $emp_id = $this->input->post('id');
        $FullName = $this->input->post('nama');
        $Division = $this->input->post('divisi');
        $Email = $this->input->post('email');
        $strPassword = $this->input->post('sandi');
        $Level = $this->input->post('lvl');
        $ApprovalLine = $this->input->post('bos');
        $strJobPosition = $this->input->post('jabatan');

        $data = array(
            'FullName' => $FullName,
            'Division' => $Division,
            'strPassword' => $strPassword,
            'Level' => $Level,
            'ApprovalLine' => $ApprovalLine,
            'strJobPosition' => $strJobPosition,
            'Email' => $Email
        );

        $this->db->where('emp_id', $emp_id);
        $this->db->update('employee', $data);
    }
}
