<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Lpbj extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }
        $this->load->model('M_Lpbj');
        $this->load->model('M_pengaturan');
        $this->load->library('upload');
        $this->load->helper(array('form', 'url'));
    }

    public function index()
    {
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        $this->load->view('lpbj/lpbj');
        $this->load->view('footer');
    }

    public function lpbj_add()
    {
        
        $tpcdb = $this->load->database('tpc', TRUE);
        $dept = $this->M_Lpbj->dept();
        $databrg = $this->M_Lpbj->tb_brg();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $datauser = $this->M_Lpbj->get_user($id);
        $usr = $this->M_pengaturan->tb_akses($id);
        $unit = $tpcdb->get_where('tb_emp_unit', ['emp_id' => $id])->result_array();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        $get_number = $this->input->get("lpbj");
        $this->load->view(
            'lpbj/tambah_lpbj',
            [
                "nmrlpbj" => $get_number,
                "brg" => $databrg,
                "dept" => $dept,
                "datauser" => $datauser,
                "unit" => $unit
            ]
        );
        $this->load->view('footer');
      
    }

    public function satuan()
    {
        $brg = $this->input->get('brg');
        $data = $this->M_Lpbj->satuan($brg);
        foreach ($data as $d) {
            if (!$d['uom1'] == '') {
                echo "<option value='" . $d['uom1'] . "'>" . $d['uom1'] . "</option>";
            }
        }
    }

    public function get_brg()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        $kd = $this->input->get('kd_brg');
        $brg = $tpcdb->get_where('tb_brg', ["kd_brg" => $kd])->row_array();
        echo $brg['brg'];
    }

    public function simpan_detail_barang()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        date_default_timezone_set('Asia/Jakarta');
        $doc_id = $this->input->post('doc_id');
        $kd = $this->input->post('kd_lpbj');
        $id = $this->session->id_user;
        $kd_brg = $this->input->post('kd_brg');
        $jml_brg = $this->input->post('jml_brg');
        $datalist_unit = $this->input->post('datalist_unit');
        $jml_stok = $this->input->post('jml_stok');
        $dept_id = $this->input->post('dept_id');
        $tgl_lpbj = $this->input->post('tgl_lpbj');
        $gambar = time() . '.' . pathinfo($_FILES['gambar_lpbj']['name'], PATHINFO_EXTENSION);
        $keterangan_lpbj = $this->input->post('keterangan_lpbj');
        $unit = $this->input->post('unitusaha');
        $cari = $this->M_Lpbj->get_number($kd);

        if (isset($_FILES['gambar_lpbj']) && $_FILES['gambar_lpbj']['error'] === UPLOAD_ERR_OK) {
            $upload_gambar = $gambar = time() . '.' . pathinfo($_FILES['gambar_lpbj']['name'], PATHINFO_EXTENSION);
        } else {
            $upload_gambar = "";
        }

        if ($cari['kd_lpbj'] == 0) {
            //input data header baru
            $data = array(
                'kd_lpbj' => $kd,
                'tgl_lpbj' => date('Y-m-d H:i:s'),
                'cr_id' => $id,
                'sts_urgent' => 0,
                'unit' => $unit,
                'sts_lpbj' => '1'
            );
            $tpcdb->insert('lpbj_h', $data);

            //input data detail

            $data = array(
                'doc_id' => time(),
                'kd_lpbj' => $kd,
                'kd_brg' => $kd_brg,
                'qty_req' => $jml_brg,
                'uom' => $datalist_unit,
                'stok' => $jml_stok,
                'dept' => $dept_id,
                'tgl' => $tgl_lpbj,
                'gambar' => $upload_gambar,
                'keterangan' => $keterangan_lpbj
            );
            $tpcdb->insert('lpbj_d', $data);
        }

        if ($cari['kd_lpbj'] > 0) {
            $data = array(
                'doc_id' => time(),
                'kd_lpbj' => $kd,
                'kd_brg' => $kd_brg,
                'qty_req' => $jml_brg,
                'uom' => $datalist_unit,
                'stok' => $jml_stok,
                'dept' => $dept_id,
                'tgl' => $tgl_lpbj,
                'gambar' => $upload_gambar,
                'keterangan' => $keterangan_lpbj
            );
            $tpcdb->insert('lpbj_d', $data);
        }


        $config['upload_path']   = './assets/img/';
        $config['allowed_types'] = 'jpeg|jpg|png';
        $config['max_size']      = 10000; // ukuran dalam KB
        $config['overwrite']     = TRUE;
        $config['quality'] = '60%';
        $config['width'] = 200;
        $config['height'] = 200;
        $config['create_thumb'] = FALSE;
        $config['maintain_ratio'] = FALSE;
        $config['file_name']     = time() . '.' . pathinfo($_FILES['gambar_lpbj']['name'], PATHINFO_EXTENSION);
        $this->load->library('image_lib', $config);
        $this->image_lib->resize();
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('gambar_lpbj')) {
            echo "0";
        } else {
            echo "1";
        }
        
    }

    public function get_spv()
    {
        $id = $this->session->id_user;
        $idspv = $this->db->get_where('employee', ["emp_id" => $id])->row_array();
        $spv = $this->db->get_where('employee', ["emp_id" => $idspv['ApprovalLine']])->row_array();
        echo $spv['FullName'];
    }

    public function get_manager()
    {
        $id = $this->input->get('e');
        //$id = $this->session->id_user;
        $datauser = $this->M_Lpbj->get_user($id);
        echo "Pembuat : " . $datauser['FullName'] . " Level : " . $datauser['Level'] . "<br>";
        echo "SPV : " . $datauser['nama_spv'] . " Level : " . $datauser['level_spv'] . "<br>";
        if ($datauser['level_manager'] == 1) {
            echo "Manager : " . $datauser['nama_spv'] . " Level : " . $datauser['level_spv'] . "<br>";
        }
        if ($datauser['level_manager'] == 2) {
            echo "Manager : " . $datauser['nama_manager'] . " Level : " . $datauser['level_manager'] . "<br>";
        }
        echo "Direktur : " . $datauser['nama_direktur'] . "<br>";
    }

    public function lpbj_list()
    {
        $kd = $this->input->get("kd");
        $datadetail = $this->M_Lpbj->lpbj_list($kd);
        $this->load->view("lpbj/tb_lpbj_list", ["data" => $datadetail]);
    }

    public function get_number()
    {
        $get_number = $this->M_Lpbj->nmr();
        echo $get_number['next_number'];
    }

    public function hapus_item()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        $kode = $this->input->post('kd');
        $brg = $this->input->post('brg');
        $gambar = $this->input->post('gambar');
        $tpcdb->delete('lpbj_d', ['kd_lpbj' => $kode, 'kd_brg' => $brg]);
        //unlink('/opt/lampp/htdocs/tpc/assets/img/' . $gambar);
        unlink('./assets/img/' . $gambar);
    }

    public function ajukan_approval()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        $id = $this->session->id_user;
        $idaprv = $this->db->get_where('employee', ["emp_id" => $id])->row_array();
        $idaprv2 = $this->db->get_where('employee', ["emp_id" => $idaprv['ApprovalLine']])->row_array();
        $kd_lpbj = $this->input->post("kd");
        $sts = $this->input->post("sts");
        $token = SHA1($idaprv['ApprovalLine'] . $kd_lpbj);

        $this->M_Lpbj->ajukan_approve($kd_lpbj, $idaprv['ApprovalLine'], $sts, $token);

        $url = base_url() . "Approve/online_approve?key=" . SHA1($idaprv['ApprovalLine'] . $kd_lpbj);

        $lpbj_h = $tpcdb->get_where("lpbj_h", ["kd_lpbj" => $kd_lpbj])->row_array();
        /*
        $lpbj_d = $this->M_Lpbj->preview_lpbj($kd_lpbj);
        $sts_aprv = $this->M_Lpbj->sts_aprv_lpbj($kd_lpbj);
        $sts_aprv_2 = $this->M_Lpbj->sts_aprv_lpbj_2($kd_lpbj);
*/
        $getusr = $this->M_Lpbj->get_user($lpbj_h['cr_id']);

        $tgl = new DateTime($lpbj_h['tgl_lpbj']);
        $fotmattgl = $tgl->format('j M Y');

        //email
        //$to_email = 'krisnatpc@gmail.com';
        //$to_email = $idaprv2['Email'];
        $to_email = 'krisna.it@tpc-pack.com';
        $subjek = '[LPBJ] Approval Request ' . $kd_lpbj;
        $pesan = '<!DOCTYPE html>
        <html lang="en">

        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Letter</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    line-height: 1.6;
                    color: #333;
                    margin: 20px;
                }

                .container {
                    max-width: 100%;
                    margin: auto;
                    padding: 20px;
                    border: 1px solid #ddd;
                    border-radius: 5px;
                    background-color: #f9f9f9;
                }

                .header {
                    text-align: center;
                    margin-bottom: 20px;
                }

                .header h1 {
                    margin: 0;
                }

                .content {
                    margin-bottom: 20px;
                }

                .content p {
                    margin: 10px 0;
                }

                .footer {
                    text-align: center;
                }

                .footer p {
                    margin: 0;
                }

                .button {
                    display: inline-block;
                    padding: 10px 20px;
                    margin: 10px 0;
                    font-size: 16px;
                    color: #fff;
                    background-color: #007BFF;
                    text-decoration: none;
                    border-radius: 5px;
                }

                .button:hover {
                    background-color: #0056b3;
                }

                table {
                    width: 100%;
                    border-collapse: collapse;
                    margin: 20px 0;
                }

                table,
                th,
                td {
                    border: 1px solid #ddd;
                }

                th,
                td {
                    padding: 2px;
                    text-align: left;
                }

                th {
                    background-color: #f2f2f2;
                }
            </style>
        </head>

        <body>
            <div class="container">
                <div class="header">
                    <h1>LPBJ Approval Request</h1>
                </div>
                <div class="content">
                    <p><b>Dear ' . $idaprv2['FullName'] . ',</b></p>
                    <p>I hope this message find you well, I have already accepted the item that ' . $getusr['FullName'] . ' wants to purchase. Please review the item immediately by clicking the link below:</p>
                    <a href="' . $url . '" class="button">Click me !</a>
                    <table>
                        <tr>
                            <th width="150px">No LPBJ</th>
                            <td>' . $kd_lpbj . '</td>
                        </tr>
                        <tr>
                            <th>Tanggal</th>
                            <td>' . $fotmattgl . '</td>
                        </tr>
                        <tr>
                            <th>Bagian/Divisi</th>
                            <td>' . $lpbj_h['unit'] . '</td>
                        </tr>
                        <tr>
                            <th>Peminta</th>
                            <td>' . $getusr['FullName'] . '</td>
                        </tr>
                        <tr>
                            <th>Supervisor</th>
                            <td>' . $getusr['nama_spv'] . '</td>
                        </tr>
                        <tr>
                            <th>Manager</th>
                            <td>' . $getusr['nama_manager'] . '</td>
                        </tr>
                        <tr>
                            <th>Direksi</th>
                            <td>' . $getusr['nama_direktur'] . '</td>
                        </tr>
                    </table>
                    <p>Thats all I have to say. Thank you for your attention.</p>
                </div>
                <div class="footer">
                    <p>Best Regards,<br>' . $getusr['FullName'] . '</p>
                </div>
            </div>
        </body>

        </html>';

        //echo $pesan;

        $from_email = 'yaniagata@yahoo.com';

        $config = [
            'protocol'  => 'smtp',
            'smtp_host' => $this->config->item('smtp'),
            'smtp_crypto' => 'tls',
            'smtp_timeout' => '4',
            'smtp_port'   => 587,
            'smtp_user' => $this->config->item('email'),
            'smtp_pass' => $this->config->item('pass'),
            'mailtype'  => 'html',
            'charset' => 'utf-8'
        ];

        $this->load->library('email');
        $this->email->initialize($config);
        $this->email->set_newline("\r\n");
        $this->email->set_crlf("\r\n");

        $this->email->from($from_email, 'LPBJ Notification');
        $this->email->to($to_email);
        $this->email->subject($subjek);
        $this->email->message($pesan);

        if ($this->email->send()) {
            //$this->session->set_flashdata("notif", "Email berhasil terkirim.");
            //redirect(base_url()); // Arahkan jika perlu
        } else {
            echo $this->email->print_debugger();
            //$this->session->set_flashdata("notif", "Email gagal dikirim.");
            //redirect(base_url()); // Arahkan jika perlu
        }
    }

    public function update_detail_barang()
    {
        $tpcdb = $this->load->database('tpc', TRUE);
        $kd_lpbj = $this->input->post("ed_kd_lpbj");
        $kd_brg = $this->input->post("ed_kd_brg");
        $jml_brg = $this->input->post("ed_jml_brg");
        $datalist_unit = $this->input->post("ed_datalist_unit");
        $jml_stok = $this->input->post("ed_jml_stok");
        $dept_id = $this->input->post("ed_dept_id");
        $tgl_lpbj = $this->input->post("ed_tgl_lpbj");
        $keterangan_lpbj = $this->input->post("ed_keterangan_lpbj");
        $nama_gambar = $this->input->post("nama_gambar");
        $kode_brg = $this->input->post("nama_brg");

        if (isset($_FILES['ed_gambar_lpbj']) && $_FILES['ed_gambar_lpbj']['error'] === UPLOAD_ERR_OK) {
            $upload_gambar = $gambar = time() . '.' . pathinfo($_FILES['ed_gambar_lpbj']['name'], PATHINFO_EXTENSION);
            unlink('/opt/lampp/htdocs/tpc/assets/img/' . $nama_gambar);
            $config['upload_path']   = './assets/img/';
            $config['allowed_types'] = 'jpeg|jpg|png';
            $config['max_size']      = 10000; // ukuran dalam KB
            $config['overwrite']     = TRUE;
            $config['quality'] = '60%';
            $config['width'] = 200;
            $config['height'] = 200;
            $config['create_thumb'] = FALSE;
            $config['maintain_ratio'] = FALSE;
            $config['file_name']     = time() . '.' . pathinfo($_FILES['ed_gambar_lpbj']['name'], PATHINFO_EXTENSION);
            $this->load->library('image_lib', $config);
            $this->image_lib->resize();
            $this->upload->initialize($config);

            if (!$this->upload->do_upload('ed_gambar_lpbj')) {
                //$data['error'] = $this->upload->display_errors();
                //$this->load->view('upload_form', $data);
                echo "0";
            } else {
                echo "1";
                //$data['upload_data'] = $this->upload->data();
                //$this->load->view('upload_success', $data);
            }

            $data = array(
                'kd_brg' => $kd_brg,
                'qty_req' => $jml_brg,
                'uom' => $datalist_unit,
                'stok' => $jml_stok,
                'dept' => $dept_id,
                'tgl' => $tgl_lpbj,
                'gambar' => $upload_gambar,
                'keterangan' => $keterangan_lpbj,
            );
            $tpcdb->update('lpbj_d', $data, ['kd_lpbj' => $kd_lpbj, 'kd_brg' => $kode_brg]);
        } else {
            $upload_gambar = "";
            $data = array(
                'kd_brg' => $kd_brg,
                'qty_req' => $jml_brg,
                'uom' => $datalist_unit,
                'stok' => $jml_stok,
                'dept' => $dept_id,
                'tgl' => $tgl_lpbj,
                'keterangan' => $keterangan_lpbj,
            );
            $tpcdb->update('lpbj_d', $data, ['kd_lpbj' => $kd_lpbj, 'kd_brg' => $kode_brg]);
        }
    }

    public function cari_lpbj()
    {
        $kd = $this->input->get("id");
        $sts = $this->M_Lpbj->sts_lpbj($kd);
        echo $sts['sts_lpbj'];
    }

    public function hitung_lpbj()
    {
        $kd = $this->input->get("id");
        $sts = $this->M_Lpbj->hitung_lpbj($kd);
        echo $sts['item_lpbj'];
    }

    public function laporan_lpbj()
    {
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        $this->load->view('lpbj/laporan_lpbj');
        $this->load->view('footer');
    }

    public function tb_laporan_lpbj()
    {
        $mulai = $this->input->get("mulai");
        $hingga = $this->input->get("hingga");
        //$sts = $this->input->get("sts");
        $data = $this->M_Lpbj->laporan_lpbj($mulai, $hingga);
        $this->load->view("lpbj/tb_laporan_lpbj", ["data" => $data]);
    }

    public function tb_laporan_lpbj_usr()
    {
        $mulai = $this->input->get("mulai");
        $hingga = $this->input->get("hingga");
        //$sts = $this->input->get("sts");
        $data = $this->M_Lpbj->laporan_lpbj_usr($mulai, $hingga);
        $this->load->view("lpbj/tb_laporan_lpbj_usr", ["data" => $data]);
    }

    public function preview_lpbj()
    {
        $lpbj = $this->input->get("lpbj");
        $id = $this->input->get("id");
        $datauser = $this->M_Lpbj->get_user($id);
        $lpbj_h = $this->db->get_where("lpbj_h", ["kd_lpbj" => $lpbj])->row_array();
        $lpbj_d = $this->M_Lpbj->preview_lpbj($lpbj);
        $cari_apprv = $this->db->get_where('tb_apprv', ['kd_lpbj' => $lpbj]);
        $this->load->view("lpbj/preview_lpbj", [
            "datauser" => $datauser,
            "lpbj" => $lpbj,
            "head" => $lpbj_h,
            "dtl" => $lpbj_d,
            "cari_apprv" => $cari_apprv
        ]);
    }

    public function approve_lpbj()
    {
        //$idusr = $this->input->get("id");
        $key = $this->input->get("key");
        $lpbj = $this->db->get_where("tb_apprv", ['token' => $key])->row_array();
        $cr_lpbj = $this->db->get_where("lpbj_h", ['kd_lpbj' => $lpbj['kd_lpbj']])->row_array();
        $lokasi = $this->session->strKdLokasi;
        $this->db->select('ID, strNmDept');
        $dept = $this->db->get_where('tpc_dept', ["stsAktif" => 1, "strKdLokasi" => $lokasi])->result_array();
        $this->db->select('brg, kd_brg');
        $databrg = $this->db->get('tb_brg')->result_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $datauser = $this->M_Lpbj->get_user($cr_lpbj['cr_id']);
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        //$get_number = $this->M_Lpbj->nmr();
        $datadetail = $this->M_Lpbj->lpbj_list_aprv($key);

        $this->load->view(
            'lpbj/approve_lpbj',
            [
                "nmrlpbj" => $lpbj,
                "brg" => $databrg,
                "dept" => $dept,
                "datauser" => $datauser,
                "key" => $key,
                "data" => $datadetail
            ]
        );

        $this->load->view('footer');
    }

    public function tb_aproval_list()
    {
        $kd = $this->input->get("kd");
        $key = $this->input->get("key");
        $datadetail = $this->M_Lpbj->lpbj_list_aprv($kd, $key);
        $this->load->view("lpbj/tb_aproval_list", ["data" => $datadetail]);
    }

    public function lpbj_approve()
    {
        date_default_timezone_set('Asia/Jakarta');
        $kd = $this->input->post('kd'); //nomor LPBJ
        $kd_brg = $this->input->post('kd_brg');
        $keterangan = $this->input->post('keterangan');
        $nmr = $this->input->post('nmr');
        $req = $this->db->get_where('lpbj_h', ["kd_lpbj" => $kd])->row_array();
        $id = $this->session->id_user;
        $idaprv = $this->db->get_where('employee', ["emp_id" => $id])->row_array();
        $idaprv2 = $this->db->get_where('employee', ["emp_id" => $idaprv['ApprovalLine']])->row_array();

        $token = SHA1($idaprv2['emp_id'] . $kd);
        $url = base_url() . "Approve/online_approve?key=" . SHA1($idaprv['ApprovalLine'] . $kd);

        $lpbj_h = $this->db->get_where("lpbj_h", ["kd_lpbj" => $kd])->row_array();
        $tgl = new DateTime($lpbj_h['tgl_lpbj']);
        $fotmattgl = $tgl->format('j M Y');

        $getusr = $this->M_Lpbj->get_user($req['cr_id']);

        $jml = count($nmr);
        for ($no = 0; $no < $jml; $no++) {
            //echo $kd . " | " . $kd_brg[$no] . " | " . $keterangan[$no] . " | " . $nmr[$no] . "<br>";

            $data = array(
                'apprv_sts' => $nmr[$no],
                'apprv_date' => date('Y-m-d H:i:s'),
                'keterangan' => $keterangan[$no]
            );
            $this->db->update('tb_apprv', $data, ['kd_lpbj' => $kd, 'doc_id' => $kd_brg[$no], 'emp_id' => $id]);
            if ($idaprv['Level'] > 1) {
                if ($nmr[$no] == 2) {
                    $this->M_Lpbj->approve($kd, $kd_brg[$no], $idaprv2['emp_id'], $idaprv2['Email'], $idaprv2['Level'], $token);
                }
            }
        }

        if ($idaprv['Level'] > 1) {
            //Kirim email ke atasan
            //$to_email = 'krisnatpc@gmail.com';
            //$to_email = $idaprv2['Email'];
            $to_email = 'krisna.it@tpc-pack.com';
            $subjek = '[LPBJ] Approval Request ' . $kd;
            $pesan = '<!DOCTYPE html>
            <html lang="en">

            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Letter</title>
                <style>
                    body {
                        font-family: Arial, sans-serif;
                        line-height: 1.6;
                        color: #333;
                        margin: 20px;
                    }

                    .container {
                        max-width: 100%;
                        margin: auto;
                        padding: 20px;
                        border: 1px solid #ddd;
                        border-radius: 5px;
                        background-color: #f9f9f9;
                    }

                    .header {
                        text-align: center;
                        margin-bottom: 20px;
                    }

                    .header h1 {
                        margin: 0;
                    }

                    .content {
                        margin-bottom: 20px;
                    }

                    .content p {
                        margin: 10px 0;
                    }

                    .footer {
                        text-align: center;
                    }

                    .footer p {
                        margin: 0;
                    }

                    .button {
                        display: inline-block;
                        padding: 10px 20px;
                        margin: 10px 0;
                        font-size: 16px;
                        color: #fff;
                        background-color: #007BFF;
                        text-decoration: none;
                        border-radius: 5px;
                    }

                    .button:hover {
                        background-color: #0056b3;
                    }

                    table {
                        width: 100%;
                        border-collapse: collapse;
                        margin: 20px 0;
                    }

                    table,
                    th,
                    td {
                        border: 1px solid #ddd;
                    }

                    th,
                    td {
                        padding: 2px;
                        text-align: left;
                    }

                    th {
                        background-color: #f2f2f2;
                    }
                </style>
            </head>

            <body>
                <div class="container">
                    <div class="header">
                        <h1>LPBJ Approval Request</h1>
                    </div>
                    <div class="content">
                        <p><b>Dear ' . $idaprv2['FullName'] . ',</b></p>
                        <p>I hope this message find you well, I have already accepted the item that ' . $getusr['FullName'] . ' wants to purchase. Please review the item immediately by clicking the link below:</p>
                        <a href="' . $url . '" class="button">Click me !</a>
                        <table>
                            <tr>
                                <th width="150px">No LPBJ</th>
                                <td>' . $kd . '</td>
                            </tr>
                            <tr>
                                <th>Tanggal</th>
                                <td>' . $fotmattgl . '</td>
                            </tr>
                            <tr>
                                <th>Bagian/Divisi</th>
                                <td>' . $lpbj_h['unit'] . '</td>
                            </tr>
                            <tr>
                                <th>Peminta</th>
                                <td>' . $idaprv['FullName'] . '</td>
                            </tr>
                            <tr>
                                <th>Supervisor</th>
                                <td>' . $getusr['nama_spv'] . '</td>
                            </tr>
                            <tr>
                                <th>Manager</th>
                                <td>' . $getusr['nama_manager'] . '</td>
                            </tr>
                            <tr>
                                <th>Direksi</th>
                                <td>' . $getusr['nama_direktur'] . '</td>
                            </tr>
                        </table>
                        <p>Thats all I have to say. Thank you for your attention.</p>
                    </div>
                    <div class="footer">
                        <p>Best Regards,<br>' . $getusr['FullName'] . '</p>
                    </div>
                </div>
            </body>

            </html>';

            //echo $pesan;

            $from_email = 'yaniagata@yahoo.com';

            $config = [
                'protocol'  => 'smtp',
                'smtp_host' => $this->config->item('smtp'),
                'smtp_crypto' => 'tls',
                'smtp_timeout' => '4',
                'smtp_port'   => 587,
                'smtp_user' => $this->config->item('email'),
                'smtp_pass' => $this->config->item('pass'),
                'mailtype'  => 'html',
                'charset' => 'utf-8'
            ];

            $this->load->library('email');
            $this->email->initialize($config);
            $this->email->set_newline("\r\n");
            $this->email->set_crlf("\r\n");

            $this->email->from($from_email, 'LPBJ Notification');
            $this->email->to($to_email);
            $this->email->subject($subjek);
            $this->email->message($pesan);

            if ($this->email->send()) {
            } else {
                echo $this->email->print_debugger();
            }
            //End Kirim email ke atasan
        }
    }

    public function final_check()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 17, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $data = $this->M_Lpbj->tb_apprv_h();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('lpbj/final_check', ["akses" => $akses, "data" => $data]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function final_check_detail()
    {
        $kd_lpbj = $this->input->get('kd');
        $lpbj = $this->db->get_where("tb_apprv", ['token' => $kd_lpbj])->row_array();
        $cr_lpbj = $this->db->get_where("lpbj_h", ['kd_lpbj' => $kd_lpbj])->row_array();
        $lokasi = $this->session->strKdLokasi;
        $this->db->select('ID, strNmDept');
        $dept = $this->db->get_where('tpc_dept', ["stsAktif" => 1, "strKdLokasi" => $lokasi])->result_array();
        $this->db->select('brg, kd_brg');
        $databrg = $this->db->get('tb_brg')->result_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 17, "akses" => 1, "id_user" => $id])->row_array();
        $datauser = $this->M_Lpbj->get_user($cr_lpbj['cr_id']);
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        //$get_number = $this->M_Lpbj->nmr();
        $datadetail = $this->M_Lpbj->tb_pr1($kd_lpbj);
        $cari = $this->db->get_where('tb_pr', ["kd_lpbj" => $kd_lpbj]);

        if (isset($akses['id'])) {
            if ($cari->num_rows() == 0) {
                $this->load->view(
                    'lpbj/final_check_dtl',
                    [
                        "nmrlpbj" => $kd_lpbj,
                        "brg" => $databrg,
                        "dept" => $dept,
                        "datauser" => $datauser,
                        "data" => $datadetail,
                        "akses" => $akses
                    ]
                );
            }

            if ($cari->num_rows() > 0) {
                echo "LPBJ telah di cek";
            }
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function final_apprv()
    {
        $kd = $this->input->post('kd'); //nomor LPBJ
        $sts = $this->input->post('nmr');
        $brg = $this->input->post('kd_brg');
        $keterangan = $this->input->post('keterangan');
        $jml = count($sts);
        for ($no = 0; $no < $jml; $no++) {
            echo $brg[$no] . "<br>";
            $this->M_Lpbj->add_tb_pr($kd, $brg[$no], $sts[$no], $keterangan[$no]);
        }
    }

    public function cari_kd_brg()
    {
        $kd = $this->input->get('kd');
        $kdbrg = $this->input->get('kdbrg');
        $query = $this->db->get_where('lpbj_d', ['kd_lpbj' => $kd, 'kd_brg' => $kdbrg]);
        if ($query->num_rows() > 0) {
            echo "1";
        }
        if ($query->num_rows() == 0) {
            echo "0";
        }
    }

    public function laporan_final_check()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 17, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);

        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('lpbj/laporan_final_check', ["akses" => $akses]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function kirim_email_ke_pengguna()
    {
        $id = $this->session->id_user;
        $kd = $this->input->post('kd_lpbj');
        $cr_id = $this->db->get_where('lpbj_h', ['kd_lpbj' => $kd])->row_array();
        $nama = $this->db->get_where('employee', ['emp_id' => $cr_id['cr_id']])->row_array();
        $apprv = $this->db->get_where('employee', ['emp_id' => $id])->row_array();

        //$to_email = $nama['Email'];
        $to_email = 'krisna.it@tpc-pack.com';
        $subjek = '[LPBJ] Approval Request ' . $kd;
        $pesan = '<!DOCTYPE html>
        <html lang="id">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>TPC-PACK</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    margin: 20px;
                    padding: 20px;
                    background-color: #f4f4f4;
                }
                .container {
                    background-color: #ffffff;
                    border-radius: 8px;
                    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                    padding: 20px;
                    max-width: 600px;
                    margin: auto;
                }
                h1 {
                    color: #333;
                }
                p {
                    line-height: 1.6;
                    color: #555;
                }
                .footer {
                    margin-top: 20px;
                    font-size: 0.9em;
                    color: #888;
                }
            </style>
        </head>
        <body>

        <div class="container">
            <h1>LPBJ ' . $kd . '</h1>
            <p><b>Dear ' . $nama['FullName'] . ',</b></p>

            <p>Thanks for youre purchase requisition, I have review youre request item, for more information please review in LPBJ Apps.</p>

            <p>Thanks & Regards,<br>
            ' . $apprv['FullName'] . '<br>
            <b></b></p>';

        if ($apprv['Level'] == 3) {
            $pesan .=  $apprv['Division'] . " SPV";
        }
        if ($apprv['Level'] == 2) {
            $pesan .=  $apprv['Division'] . " MANAGER";
        }
        if ($apprv['Level'] == 1) {
            $pesan .= "DIREKTUR";
        }

        $pesan .= '<div class="footer">
                <a href="https://portal.gpc-pack.com/">https://portal.gpc-pack.com/</a>
            </div>
        </div>

        </body>
        </html>';

        $from_email = 'yaniagata@yahoo.com';

        $config = [
            'protocol'  => 'smtp',
            'smtp_host' => $this->config->item('smtp'),
            'smtp_crypto' => 'tls',
            'smtp_timeout' => '4',
            'smtp_port'   => 587,
            'smtp_user' => $this->config->item('email'),
            'smtp_pass' => $this->config->item('pass'),
            'mailtype'  => 'html',
            'charset' => 'utf-8'
        ];


        $this->load->library('email');
        $this->email->initialize($config);
        $this->email->set_newline("\r\n");
        $this->email->set_crlf("\r\n");

        $this->email->from($from_email, 'LPBJ Notification');
        $this->email->to($to_email);
        $this->email->subject($subjek);
        $this->email->message($pesan);

        if ($this->email->send()) {
            echo "1";
        } else {
            echo $this->email->print_debugger();
        }
    }
}
