<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;

class Logistik extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }

        $this->load->library('Pdf');
        $this->load->model('M_gudang');
        $this->load->model('M_pengaturan');
    }

    public function spb()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 37, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('gudang/spb', ['akses' => $akses]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function preview_spb()
    {
        date_default_timezone_set('Asia/Jakarta');
        $allowedFileType = [
            'application/vnd.ms-excel',
            'text/xls',
            'text/xlsx',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
        ];

        if (in_array($_FILES["file_xls"]["type"], $allowedFileType)) {

            $targetPath = './uploads/' . $_FILES['file_xls']['name'];
            move_uploaded_file($_FILES['file_xls']['tmp_name'], $targetPath);

            $Reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();

            $spreadSheet = $Reader->load($targetPath);
            $excelSheet = $spreadSheet->getActiveSheet();
            $spreadSheetAry = $excelSheet->toArray();
            $sheetCount = (count($spreadSheetAry) - 1);

            echo "<br>";
            echo "<table class='table table-sm table-bordered'>";
            echo "<thead>";
            echo "<th>#</th>";
            echo "<th>Tgl</th>";
            echo "<th>No SO</th>";
            echo "<th>Nama Pelanggan</th>";
            echo "<th>Kirim ke 1</th>";
            echo "<th>Keterangan Detail</th>";
            echo "<th>Kuantitas</th>";
            echo "<th>Kts</th>";
            echo "</thead>";
            echo "<tbody>";
            for ($i = 1; $i <= $sheetCount; $i++) {
                if (isset($spreadSheetAry[$i][0])) {
                    $cari = $this->db->get_where('tb_spb', [
                        'tgl_spb' => $spreadSheetAry[$i][0],
                        'no_so' => $spreadSheetAry[$i][1],
                        'customer' => $spreadSheetAry[$i][2],
                        'shipto' => $spreadSheetAry[$i][3],
                        'remark' => $spreadSheetAry[$i][4],
                        'qty' => $spreadSheetAry[$i][5],
                        'qty_s' => $spreadSheetAry[$i][6]
                    ]);
                    $c = $cari->num_rows();
                    if ($c == 0) {
                        echo "<tr>";
                        echo "<td>" . $i . "</td>";
                        echo "<td>" . $spreadSheetAry[$i][0] . "</td>";
                        echo "<td>" . $spreadSheetAry[$i][1] . "</td>";
                        echo "<td>" . $spreadSheetAry[$i][2] . "</td>";
                        echo "<td>" . $spreadSheetAry[$i][3] . "</td>";
                        echo "<td>" . $spreadSheetAry[$i][4] . "</td>";
                        echo "<td>" . $spreadSheetAry[$i][5] . "</td>";
                        echo "<td>" . $spreadSheetAry[$i][6] . "</td>";
                        echo "</tr>";
                    } else {
                        if ($c == 1) {
                            echo "<tr class='table-danger'>";
                            echo "<td>" . $i . "</td>";
                            echo "<td>" . $spreadSheetAry[$i][0] . "</td>";
                            echo "<td>" . $spreadSheetAry[$i][1] . "</td>";
                            echo "<td>" . $spreadSheetAry[$i][2] . "</td>";
                            echo "<td>" . $spreadSheetAry[$i][3] . "</td>";
                            echo "<td>" . $spreadSheetAry[$i][4] . "</td>";
                            echo "<td>" . $spreadSheetAry[$i][5] . "</td>";
                            echo "<td>" . $spreadSheetAry[$i][6] . "</td>";
                            echo "</tr>";
                        }
                    }
                }
            }
            echo "</tbody>";
            echo "</table>";
        } else {
            $type = "error";
            $message = "Invalid File Type. Upload Excel File.";
        }
    }

    public function upload_spb()
    {
        date_default_timezone_set('Asia/Jakarta');
        $allowedFileType = [
            'application/vnd.ms-excel',
            'text/xls',
            'text/xlsx',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
        ];

        if (in_array($_FILES["file_xls"]["type"], $allowedFileType)) {

            $targetPath = './uploads/' . $_FILES['file_xls']['name'];
            move_uploaded_file($_FILES['file_xls']['tmp_name'], $targetPath);

            $Reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();

            $spreadSheet = $Reader->load($targetPath);
            $excelSheet = $spreadSheet->getActiveSheet();
            $spreadSheetAry = $excelSheet->toArray();
            $sheetCount = (count($spreadSheetAry) - 1);

            for ($i = 1; $i <= $sheetCount; $i++) {
                if (isset($spreadSheetAry[$i][0])) {
                    $cari = $this->db->get_where('tb_spb', [
                        'tgl_spb' => $spreadSheetAry[$i][0],
                        'no_so' => $spreadSheetAry[$i][1],
                        'customer' => $spreadSheetAry[$i][2],
                        'shipto' => $spreadSheetAry[$i][3],
                        'remark' => $spreadSheetAry[$i][4],
                        'qty' => $spreadSheetAry[$i][5],
                        'qty_s' => $spreadSheetAry[$i][6]
                    ]);
                    $c = $cari->num_rows();
                    if ($c == 0) {
                        $data = array(
                            'tgl_spb' => $spreadSheetAry[$i][0],
                            'no_so' => $spreadSheetAry[$i][1],
                            'customer' => $spreadSheetAry[$i][2],
                            'shipto' => $spreadSheetAry[$i][3],
                            'remark' => $spreadSheetAry[$i][4],
                            'qty' => $spreadSheetAry[$i][5],
                            'qty_s' => $spreadSheetAry[$i][6]
                        );
			$this->db->insert('tb_spb', $data);
                    }                    
                }
            }
            unlink('./uploads/' . $_FILES['file_xls']['name']);
        } else {
            $type = "error";
            $message = "Invalid File Type. Upload Excel File.";
        }
    }

    public function tb_spb()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $noso = $this->input->get('noso');
        $noso_array = explode(',', $noso);
        $noso_array_quoted = array_map(function ($item) {
            return "'" . $item . "'";
        }, $noso_array);
        $noso_quoted = implode(',', $noso_array_quoted);
        $data = $this->M_gudang->tb_spb($s, $e, $noso_quoted);
        $this->load->view('gudang/tb_spb', ['data' => $data]);
    }

    public function simpan_spb()
    {
        $id = $this->input->post('id_spb');
        $qty = $this->input->post('qty_spb');
        $data = array(
            'qty_spb' => $qty
        );

        $this->db->where('id_spb', $id);
        $this->db->update('tb_spb', $data);
    }

    public function get_so()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $so = $this->M_gudang->get_so($s, $e);
        foreach ($so as $s) {
            echo "<option value='" . $s['no_so'] . "'>" . $s['no_so'] . "</option>";
        }
    }

    public function cetak_spb()
    {
        date_default_timezone_set('Asia/Jakarta');
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $noso = $this->input->get('noso');
        $noso_array = explode(',', $noso);
        $noso_array_quoted = array_map(function ($item) {
            return "'" . $item . "'";
        }, $noso_array);
        $noso_quoted = implode(',', $noso_array_quoted);
        $data = $this->M_gudang->tb_spb($s, $e, $noso_quoted);
        $pdf = new \TCPDF();
        $leftMargin = 7;
        $topMargin = 5;
        $rightMargin = 1;
        $bottomMargin = 1;
        $pdf->SetMargins($leftMargin, $topMargin, $rightMargin);
        $pdf->AddPage('P', 'mm', 'A4');
        $pdf->SetFont('', 'B', 14);
        $pdf->Cell(200, 10, "SURAT PERMINTAAN BARANG (SPB)", 0, 1, 'C');
        $pdf->SetAutoPageBreak(true, 0);
        // Add Header
        $pdf->Ln(3);
        $pdf->SetFont('', 'B', 10);
        $pdf->Cell(8, 6, "NO.", 1, 0, 'C');
        $pdf->Cell(22, 6, "TGL SO", 1, 0, 'C');
        $pdf->Cell(20, 6, "NO SO", 1, 0, 'C');
        $pdf->Cell(35, 6, "ORDER", 1, 0, 'C');
        $pdf->Cell(35, 6, "KIRIM KE", 1, 0, 'C');
        $pdf->Cell(65, 6, "NAMA BARANG", 1, 0, 'C');
        $pdf->Cell(10, 6, "QTY", 1, 1, 'C');
        $pdf->SetFont('', '', 9);
        $no = 0;
        foreach ($data as $d) {
            $no++;
            $pdf->MultiCell(8, 11, $no, 1, 'C', 0, 0, '', '', true);
            $pdf->MultiCell(22, 11, $d['tgl_spb'], 1, 'L', 0, 0, '', '', true);
            $pdf->MultiCell(20, 11, $d['no_so'], 1, 'L', 0, 0, '', '', true);
            $pdf->MultiCell(35, 11, $d['customer'], 1, 'L', 0, 0, '', '', true);
            $pdf->MultiCell(35, 11, $d['shipto'], 1, 'L', 0, 0, '', '', true);
            $pdf->MultiCell(65, 11, $d['remark'], 1, 'L', 0, 0, '', '', true);
            $pdf->MultiCell(10, 11, $d['qty_spb'], 1, 'R', 0, 1, '', '', true);
        }
        $pdf->SetFont('', '', 8);
        $pdf->MultiCell(30, 30, "TANGGAL : " . date('d-m-y'), 1, 'L', 0, 0, '', '', true);
        $pdf->Cell(20, 6, "Jam SPB", 1, 0, 'L');
        $pdf->Cell(35, 6, "", 1, 0, 'C');
        $pdf->MultiCell(60, 30, "DICHECK & DITERIMA OLEH", 1, 'C', 0, 0, '', '', true);
        $pdf->MultiCell(50, 30, "TANGGAL : ", 1, 'C', 0, 0, '', '', true);
        $pdf->Cell(1, 6, "", 0, 1, 'C');
        $pdf->Cell(30, 6, "DIAJUKAN OLEH :", 0, 0, 'C');
        $pdf->Cell(20, 6, "Jam Prepare", 1, 0, 'L');
        $pdf->Cell(35, 6, "", 0, 0, 'C');
        $pdf->Cell(60, 6, "", 0, 0, 'C');
        $pdf->Cell(50, 6, "DISERAHKAN OLEH :", 0, 1, 'C');
        $pdf->Cell(30, 6, "", 0, 0, 'C');
        $pdf->Cell(20, 6, "Jam Muat", 1, 0, 'L');
        $pdf->Cell(35, 6, "", 1, 1, 'C');
        $pdf->Cell(30, 6, "", 0, 0, 'C');
        $pdf->Cell(20, 6, "Jam SJ", 1, 0, 'L');
        $pdf->Cell(35, 6, "", 1, 1, 'C');
        $pdf->SetFont('', '', 7);
        $pdf->Cell(30, 6, "", 0, 0, 'C');
        $pdf->Cell(20, 6, "Berangkat Kirim", 1, 0, 'L');
        $pdf->Cell(35, 6, "", 1, 1, 'C');
        $pdf->Output('Laporan-Tcpdf-CodeIgniter.pdf');
    }

}
