<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Home extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }

        $this->load->library('Pdf');
        $this->load->model('M_sql');
        $this->load->model('M_pengaturan');
    }

    public function index()
    {
        $id = $this->session->id_user;
        $grup = $this->db->get('tb_group_menu')->result_array();
	$sub = $this->M_pengaturan->tb_menu();
        $usr = $this->M_pengaturan->tb_akses($id);
	$stok = $this->M_sql->tb_stok();
        $kirim = $this->M_sql->info_kirim();
	$recv =  $this->M_sql->recv_monitor_fanny();
	$lpbj = $this->M_sql->get_pengajuan_lpbj();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        $this->load->view('dashboard', ["lpbj" => $lpbj, 'stok' => $stok, 'recv' => $recv]);
        $this->load->view('footer');
    }

    public function tb_dashboard()
    {
        $lpbj = $this->M_sql->get_pengajuan_lpbj();
        $this->load->view('tb_dashboard', ["lpbj" => $lpbj]);
    }

    public function tb_aproval_list()
    {
        $kd = $this->input->get("kd");
        $datadetail = $this->M_sql->lpbj_list($kd);
        $this->load->view("tb_aproval_list", ["data" => $datadetail]);
    }

   public function tb_recv_monitor()
    {
        $data = $this->M_sql->recv_monitor_fanny();
        $this->load->view('dashboard/tb_recv_monitor', ['data' => $data]);
    }

    public function tb_dtl_recv_monitor()
    {
        $sku = $this->input->get('sku');
        $data = $this->M_sql->detail_recv_monitor_fanny($sku);
        $this->load->view('dashboard/tb_dtl_recv_monitor', ['data' => $data]);
    }

    public function tb_stok()
   {
   $stok = $this->M_sql->tb_stok();
   echo json_encode($stok);
   }

}
