<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Gudang extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (isset($this->session->id_user) == false) {
            redirect(base_url('Auth'));
        }
        $this->load->library('Pdf');
        $this->load->model('M_gudang');
        $this->load->model('M_pengaturan');
    }

    public function penerimaan_fg()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 8, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('penerimaanfg');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function scan_fg()
    {
        $fg = $this->input->post('id');
        $data = $this->M_gudang->scan_fg($fg);
        echo $data['cari'];
    }

    public function cari_fg_gudang()
    {
        $fg = $this->input->post('id');
        $data = $this->M_gudang->cari_fg_gudang($fg);
        echo $data['cari_bj_gudang'];
    }

    public function cari_fg_gudang2()
    {
        $fg = $this->input->post('id');
        $data = $this->M_gudang->cari_fg_gudang2($fg);
        echo $data['cari_bj_gudang'];
    }

    public function fg_diterima_gudang()
    {
        $fg = $this->input->post('id');
        $this->M_gudang->fg_diterima_gudang($fg);
    }

    public function fg_list()
    {
        $data = $this->M_gudang->fg_list();
        $this->load->view('fg_list', ["resultbj" => $data]);
    }

    public function laporan_penerimaan_fg()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 14, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('laporan_penerimaan_fg');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_laporan_penerimaan_fg()
    {
        $mulai = $this->input->get('mulai');
        $hingga = $this->input->get('hingga');
        $data = $this->M_gudang->laporan_penerimaan_fg($mulai, $hingga);
        $this->load->view('tb_laporan_penerimaan_fg', ["resultlot" => $data]);
    }

    public function tb_laporan_penerimaan_fg_xls()
    {
        $mulai = $this->input->get('mulai');
        $hingga = $this->input->get('hingga');

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        $data = $this->M_gudang->laporan_penerimaan_fg($mulai, $hingga);
        $i = 2;
        $no = 1;
        $sheet->setCellValue('A1', 'No.');
        $sheet->setCellValue('B1', 'No LOT');
        $sheet->setCellValue('C1', 'SKU');
        $sheet->setCellValue('D1', 'Nama Barang');
        $sheet->setCellValue('E1', 'Tgl Kirim');
        $sheet->setCellValue('F1', 'Tgl Diterima');
        foreach ($data as $l) {
            $sheet->setCellValue('A' . $i, $no++);
            $sheet->setCellValue('B' . $i, $l['kode_fg']);
            $sheet->setCellValue('C' . $i, $l['sku']);
            $sheet->setCellValue('D' . $i, $l['barang']);
            $sheet->setCellValue('E' . $i, $l['tgl_kirim']);
            $sheet->setCellValue('F' . $i, $l['tgl_scan']);
            $i++;
        }

        $styleArray = [
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],
        ];
        $i = $i - 1;
        $sheet->getStyle('A1:F' . $i)->applyFromArray($styleArray);

        $writer = new Xlsx($spreadsheet);
        $filename = 'Laporan_penerimaan_FG.xlsx';

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output'); // Unduh file ke browser
        exit;
    }

    public function tes()
    {
        // Membuat Spreadsheet baru
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Menambahkan data ke dalam sel
        $sheet->setCellValue('A1', 'Nama');
        $sheet->setCellValue('B1', 'Umur');
        $sheet->setCellValue('A2', 'John Doe');
        $sheet->setCellValue('B2', 28);
        $sheet->setCellValue('A3', 'Jane Doe');
        $sheet->setCellValue('B3', 25);

        // Menyimpan file Excel
        $writer = new Xlsx($spreadsheet);
        $filename = 'contoh_excel.xlsx';

        // Set header untuk mengunduh file
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output'); // Unduh file ke browser
        exit;
    }

    public function pengiriman()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 9, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $kendaraan = $this->db->get("tb_kendaraan")->result_array();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('pengiriman', ["kendaraan" => $kendaraan]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function cari_kode_kirim1()
    {
        $kode = $this->input->get('kode');
        $hasil = $this->db->query("select count(kode_fg) as kode_fg 
        from tb_fg_gudang 
        where kode_fg = '$kode' and tgl_diterima is not null;")->row_array();
        echo $hasil['kode_fg'];
    }

    public function cari_kode_kirim2()
    {
        $kode = $this->input->get('kode');
        $hasil = $this->db->query("select count(kode_fg) as kode_fg 
        from tb_fg_gudang 
        where kode_fg = '$kode' and tgl_diterima is not null and tgl_kirim is null;")->row_array();
        echo $hasil['kode_fg'];
    }

    public function cari_kode_kirim_simpan()
    {
        $kode = $this->input->post('kode_fg');
        $no_sj = $this->input->post('no_sj');
        $kendaraan = $this->input->post('kendaraan');
        $data = array(
            'no_sj' => $no_sj,
            'id_kendaraan' => $kendaraan,
            'tgl_kirim' => date('Y-m-d H:i:s')
        );
        $this->db->where('kode_fg', $kode);
        $this->db->update('tb_fg_gudang', $data);
    }

    public function hitung_kirim()
    {
        $kendaraan = $this->input->get('kendaraan');
        $no_sj = $this->input->get('no_sj');
        $row = $this->db->query("select count(kode_fg) as kode_fg 
        from tb_fg_gudang 
        where id_kendaraan = $kendaraan and no_sj = '$no_sj';")->row_array();
        echo $row['kode_fg'];
    }

    public function cek_pengiriman()
    {
        $kendaraan = $this->input->get('kendaraan');
        $no_sj = $this->input->get('no_sj');
        $data = $this->M_gudang->cek_pengiriman($kendaraan, $no_sj);
        $this->load->view('tb_pengiriman', ["data" => $data]);
    }

    public function stok_gudang()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 15, "akses" => 1, "id_user" => $id])->row_array();
	$fg = $this->db->get('tb_fg')->result_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
	$gudang = $this->M_gudang->get_gudang_trace_grup();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('gudang/laporan_stok', ["fg" => $fg, "akses" => $akses, "gudang" => $gudang]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_stok_gudang()
    {
        $mulai = $this->input->get('s');
        $hingga = $this->input->get('e');
        $data = $this->M_gudang->stok_gudang($mulai, $hingga);
        $this->load->view('tb_stok_gudang', ["data" => $data]);
    }

    public function tb_trace_stok()
    {
        $kd = $this->input->get('kd');
        $gudang = $this->input->get('gudang');
        $detail = $this->M_gudang->trace_stok($kd, $gudang);
        echo "<table class='table table-sm'>";
        echo "<thead>";
        echo "<th>#</th>";
        echo "<th>Tgl</th>";
        //echo "<th>Gudang</th>";
        echo "<th style='text-align: right;'>Stok In</th>";
        echo "<th style='text-align: right;'>Stok Out</th>";
        echo "<th style='text-align: right;'>Balance</th>";
        echo "</thead>";
        echo "<tbody>";
        $i = 1;
        foreach ($detail as $d) {
            //$gudang = $this->M_gudang->get_gudang_trace($kd, $d['tanggal']);
            echo "<tr>";
            echo "<td>" . $i . "</td>";
            echo "<td>" . $d['tgl'] . "</td>";
            echo "<td style='text-align: right;'>" . $d['qty_in'] . "</td>";
            echo "<td style='text-align: right;'>" . $d['qty_out'] . "</td>";
            echo "<td style='text-align: right;'>" . $d['stok'] . "</td>";
            echo "</tr>";
            $i++;
        }
        echo "</tbody>";
        echo "</table>";
    }

    public function laporan_stok()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 16, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $fg = $this->db->get('tb_fg')->result_array();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('laporan_stok_1', ["fg" => $fg]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function adj_stok()
    {
	//$data = $this->db->get('tb_audit_2025_01_17')->result_array();        
	//$data = $this->db->get('tb_sub_menu')->result_array();        
        $data = $this->db->query("SELECT * FROM employee WHERE email = 'krisna.it@tpc-pack.com';");
	echo json_encode($data);
	//echo"Ok";
    }

    public function tb_monitor_stok()
    {
        $mulai = $this->input->get('s');
        $hingga = $this->input->get('e');
        $kode = $this->input->get('k');
        $data = $this->M_gudang->monitor_stok($mulai, $hingga, $kode);
        echo "<table class='table table-sm table-bordered'>";
        echo "<thead>";
        echo "<tr>";
        echo "<th width='35px' rowspan='2'>#</th>";
        echo "<th width='115px' rowspan='2'>Tgl</th>";
        echo "<th rowspan='2'>No Doc</th>";
        echo "<th rowspan='2'>Keterangan</th>";
        echo "<th colspan='3' style='text-align: center;'>Jumlah FG</th>";
        echo "<th width='50px' style='text-align: right;' rowspan='2'>Balance</th>";
        echo "</tr>";
        echo "<tr>";
        echo "<th width='50px' style='text-align: right;'>Transfer</th>";
        echo "<th width='50px' style='text-align: right;'>IN</th>";
        echo "<th width='50px' style='text-align: right;'>OUT</th>";
        echo "</tr>";
        echo "</thead>";
        echo "<tbody>";
        $i = 1;
        $stok_in = 0;
        $stok_out = 0;
        $tf = 0;
        foreach ($data as $d) {
            $stokin = $d['qty_in'];
            $stokout = $d['qty_out'];
                echo "<tr>";
                echo "<td>" . $i . "</td>";
                echo "<td>" . $d['tgl'] . "</td>";
                echo "<td>" . $d['doc_tf'] . "</td>";
                echo "<td>" . $d['keterangan'] . "</td>";
                echo "<td style='text-align: right;'>" . $d['qty_tf'] . "</td>";
                echo "<td style='text-align: right;'>" . $d['qty_in'] . "</td>";
                echo "<td style='text-align: right;'>" . $d['qty_out'] . "</td>";
                //echo "<td style='text-align: right;'>" . ($stok_in + $stokin) - ($stok_out + $stokout) . "</td>";
                echo "<td style='text-align: right;'>" . $d['balance'] . "</td>";
                echo "</tr>";
                $tf += $d['qty_tf'];
                $stok_in += $d['qty_in'];
                $stok_out += $d['qty_out'];
            
            $i++;
        }
        echo "</tbody>";
        echo "<tfoot>";
        echo "<td style='text-align: center;' colspan='3'><b>TOTAL</b></td>";
        echo "<td style='text-align: right;'><b>" . $tf . "</b></td>";
        echo "<td style='text-align: right;'><b>" . $stok_in . "</b></td>";
        echo "<td style='text-align: right;'><b>" . $stok_out . "</b></td>";
        echo "<td style='text-align: right;'></td>";
        echo "</tfoot>";
        echo "</table>";
    }

   

    public function tb_saldo_stok()
    {
        $thn = $this->input->get('thn');
        $bln = $this->input->get('bln');
        $data = $this->M_gudang->saldo_stok($thn, $bln);
        $this->load->view('gudang/tb_saldo_stok', ["data" => $data, 'thn' => $thn, 'bln' => $bln]);
    }
    
    public function tb_saldo_stok_xls()
    {
        $thn = $this->input->get('thn');
        $bln = $this->input->get('bln');
        $data = $this->M_gudang->saldo_stok($thn, $bln);
        $this->load->view('gudang/tb_saldo_stok_xls', ["data" => $data, 'thn' => $thn, 'bln' => $bln]);
    }
    
    public function recv_rep()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 23, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $fg = $this->db->get('tb_fg')->result_array();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('gudang/recv_report', ["fg" => $fg, "akses" => $akses]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_recv()
    {
        $mulai = $this->input->get('s');
        $hingga = $this->input->get('e');
        $data = $this->M_gudang->tb_recv($mulai, $hingga);
        $this->load->view('gudang/tb_recv', ['data' => $data]);
    }
    
    public function tb_recv_xls()
    {
        $mulai = $this->input->get('s');
        $hingga = $this->input->get('e');
        $data = $this->M_gudang->tb_recv($mulai, $hingga);
        $this->load->view('gudang/tb_recv_xls', ['data' => $data]);
    }
    
    public function cari_kode_kirim_simpan2()
    {
        date_default_timezone_set('Asia/Jakarta');
        $kode = $this->input->post('kode_fg');
        $sj = $this->input->post('no_sj');
        $kendaraan = $this->input->post('kendaraan');
        $data = array(
            'id_kendaraan' => $kendaraan,
            'tgl_kirim' => date('Y-m-d H:i:s'),
            'no_sj' => $sj
        );
        $this->db->where('kode_fg', $kode);
        $this->db->update('tb_fg_gudang', $data);
    }

    public function ritase()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 27, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('gudang/ritase', ['akses' => $akses]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }



    public function tb_ritase()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
	$id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 27, "akses" => 1, "id_user" => $id])->row_array();
        $dataritase = $this->M_gudang->tb_ritase($s, $e);
        $this->load->view('gudang/tb_ritase', ['data' => $dataritase,'akses' => $akses]);
    }

    public function tb_ritase_xls()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $dataritase = $this->M_gudang->tb_ritase($s, $e);
        $this->load->view('gudang/tb_ritase_xls', ['data' => $dataritase]);
    }
    
    public function tb_pengiriman()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $data = $this->M_gudang->tb_pengiriman($s, $e);
        $this->load->view('gudang/tb_pengiriman', ['data' => $data]);
    }

    public function laporan_pengiriman()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 28, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('gudang/laporan_pengiriman', ["akses" => $akses]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }
    
    public function tb_pengiriman_xls()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $data = $this->M_gudang->tb_pengiriman($s, $e);
        $this->load->view('gudang/tb_pengiriman_xls', ['data' => $data]);
    }
    
    public function cetak_sj()
    {
        $sj = $this->input->get('sj');
        $head = $this->M_gudang->sj_head($sj);
        $detail = $this->M_gudang->hitung_fg_nopol($sj);
        $this->load->view('gudang/cetaksj', ['head' => $head, 'detail' => $detail]);
    }

    public function laporan_sj()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 34, "akses" => 1, "id_user" => $id])->row_array();

        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('gudang/laporan_sj', ['akses' => $akses]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_sj()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $data = $this->M_gudang->get_sj($s, $e);
        $this->load->view('gudang/tb_sj', ['data' => $data]);
    }

    public function tb_sj_xls()
    {
        $s = $this->input->get('s');
        $e = $this->input->get('e');
        $data = $this->M_gudang->get_sj($s, $e);
        $this->load->view('gudang/tb_sj_xls', ['data' => $data]);
    }

    public function get_count_penerimaan()
    {
        $lot = $this->input->get('lot');
        $hitung = $this->M_gudang->get_count_penerimaan($lot);
        echo "<table class='table table-sm table-borderless'>";
        echo "<td>" . $hitung['barang'] . "</td>";
        echo "<td><span class='badge bg-primary'>" . $hitung['penerimaan'] . "</span></td>";
        echo "</table>";
    }

    public function get_gudang()
    {
        $sku = $this->input->get('sku');
        $thn = $this->input->get('thn');
        $bln = $this->input->get('bln');
        $gudang = $this->M_gudang->get_gudang($sku, $thn, $bln);
        foreach ($gudang as $g) {
            echo "<option value='" . $g['id_gudang'] . "'>" . $g['gudang'] . "</option>";
        }
    }

    public function stok_gudang_harian()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 43, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $gudang = $this->M_gudang->get_gudang_trace_grup();
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('gudang/laporan_stok_harian', ["akses" => $akses, "gudang" => $gudang]);
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function tb_saldo_stok_harian()
    {
        $tgl = $this->input->get('tgl');
        $gudang = $this->M_gudang->get_gudang_trace_grup();
        $list_gudang = [];

        foreach ($gudang as $key => $value) {
            array_push($list_gudang, $value);
        }

        $list_brg = $this->M_gudang->get_brg($tgl);
        $sku = [];

        foreach ($list_brg as $b) {
            $data = [];
            $data['barang'] = $b['barang'];
            $data['sku'] = $b['sku'];

            foreach ($list_gudang as $gdg) {
                $row = $this->M_gudang->trace_stok_harian($b['sku'], $gdg['id_gudang'], $tgl);
                if (count($row) > 0) {
                    $data[$gdg['id_gudang']] = $row[0]['stok'];
                } else {
                    $data[$gdg['id_gudang']] = 0;
                }
            }
            array_push($sku, $data);
        }

        $pivot_data = [];
        $pivot_data['gudang'] = [];
        $pivot_data['barang'] = [];
        $pivot_data['sku'] = [];
        $pivot_data['stok'] = [];

        foreach ($list_gudang as $gdg) {
            $pivot_data['gudang'][] = $gdg['gudang'];
        }

        foreach ($sku as $item) {
            $pivot_data['barang'][] = $item['barang'];
            $pivot_data['sku'][] = $item['sku'];


            $stok_per_barang = [];
            foreach ($list_gudang as $gdg) {
                $stok_per_barang[] = isset($item[$gdg['id_gudang']]) ? $item[$gdg['id_gudang']] : 0;
            }
            $pivot_data['stok'][] = $stok_per_barang;
        }

        $this->load->view('gudang/tb_saldo_stok_harian', ['pivot_data' => $pivot_data]);
    }

    public function tb_saldo_stok_harian_xls()
    {
        $tgl = $this->input->get('tgl');
        date_default_timezone_set('Asia/Jakarta');
        $cetak =  date('Y-m-d');
        $gudang = $this->M_gudang->get_gudang_trace_grup();
        $list_gudang = [];

        foreach ($gudang as $key => $value) {
            array_push($list_gudang, $value);
        }

        $list_brg = $this->M_gudang->get_brg($tgl);
        $sku = [];

        foreach ($list_brg as $b) {
            $data = [];
            $data['barang'] = $b['barang'];
            $data['sku'] = $b['sku'];

            foreach ($list_gudang as $gdg) {
                $row = $this->M_gudang->trace_stok_harian($b['sku'], $gdg['id_gudang'], $tgl);
                if (count($row) > 0) {
                    $data[$gdg['id_gudang']] = $row[0]['stok'];
                } else {
                    $data[$gdg['id_gudang']] = 0;
                }
            }
            array_push($sku, $data);
        }

        $pivot_data = [];
        $pivot_data['gudang'] = [];
        $pivot_data['barang'] = [];
        $pivot_data['sku'] = [];
        $pivot_data['stok'] = [];

        foreach ($list_gudang as $gdg) {
            $pivot_data['gudang'][] = $gdg['gudang'];
        }

        foreach ($sku as $item) {
            $pivot_data['barang'][] = $item['barang'];
            $pivot_data['sku'][] = $item['sku'];
            $stok_per_barang = [];
            foreach ($list_gudang as $gdg) {
                $stok_per_barang[] = isset($item[$gdg['id_gudang']]) ? $item[$gdg['id_gudang']] : 0;
            }
            $pivot_data['stok'][] = $stok_per_barang;
        }
        $this->load->view('gudang/tb_saldo_stok_harian_xls', ['pivot_data' => $pivot_data, 'tgl' => $tgl, 'cetak' => $cetak]);
    }

    public function tb_fg_gudang()
    {
        $tgl1 = date('Y-m-d', strtotime($this->input->get('tgl1')));
        $tgl2 = date('Y-m-d', strtotime($this->input->get('tgl2')));
        $lot = $this->input->get('lot');
        $data = $this->M_gudang->tb_fg_gudang($tgl1, $tgl2, $lot);
        echo json_encode($data);
    }

    public function tb_fg()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 45, "akses" => 1, "id_user" => $id])->row_array();
        $id = $this->session->id_user;
        if (isset($akses['id'])) {
            $this->load->view("gudang/tb_fg");
        } else {
            $this->load->view('halaman_404');
        }
    }

    public function tb_fg_gudang_xls()
    {
        $tgl1 = date('Y-m-d', strtotime($this->input->get('tgl1')));
        $tgl2 = date('Y-m-d', strtotime($this->input->get('tgl2')));
        $lot = $this->input->get('lot');
        $data = $this->M_gudang->tb_fg_gudang($tgl1, $tgl2, $lot);
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $i = 2;
        $no = 1;
        $sheet->setCellValue('A1', 'No.');
        $sheet->setCellValue('B1', 'NOMOR LOT');
        $sheet->setCellValue('C1', 'SKU');
        $sheet->setCellValue('D1', 'BARANG');
        $sheet->setCellValue('E1', 'SHIFT');
        $sheet->setCellValue('F1', 'MESIN');
        $sheet->setCellValue('G1', 'ID PRODUKSI');
        $sheet->setCellValue('H1', 'TGL LOT');
        $sheet->setCellValue('I1', 'TGL TRANSFER');
        $sheet->setCellValue('J1', 'TGL DITERIMA');
        $sheet->setCellValue('K1', 'TGL KIRIM');
        $sheet->setCellValue('L1', 'NO POL');
        $sheet->setCellValue('M1', 'NO SJ');
        $sheet->setCellValue('N1', 'DOC NO');
        $sheet->setCellValue('O1', 'GUDANG');
        foreach ($data as $l) {
            $sheet->setCellValue('A' . $i, $no++);
            $sheet->setCellValue('B' . $i, $l['kode_fg']);
            $sheet->setCellValue('C' . $i, $l['sku']);
            $sheet->setCellValue('D' . $i, $l['barang']);
            $sheet->setCellValue('E' . $i, $l['shift']);
            $sheet->setCellValue('F' . $i, $l['mesin']);
            $sheet->setCellValue('G' . $i, $l['id_produksi']);
            $sheet->setCellValue('H' . $i, $l['tgl']);
            $sheet->setCellValue('I' . $i, $l['tgl_transfer']);
            $sheet->setCellValue('J' . $i, $l['tgl_diterima']);
            $sheet->setCellValue('K' . $i, $l['tgl_kirim']);
            $sheet->setCellValue('L' . $i, $l['no_pol']);
            $sheet->setCellValue('M' . $i, $l['no_sj']);
            $sheet->setCellValue('N' . $i, $l['doc_tf']);
            $sheet->setCellValue('O' . $i, $l['gudang']);
            $i++;
        }
        $styleArray = [
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],
        ];
        $i = $i - 1;
        $sheet->getStyle('A1:N' . $i)->applyFromArray($styleArray);

        $writer = new Xlsx($spreadsheet);
        $filename = 'LOT_LIST.xlsx';

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output'); // Unduh file ke browser
        exit;
    }

    public function scan_cari()
    {
        $id = $this->session->id_user;
        $akses = $this->db->get_where('tb_akses', ['id_menu' => 48, "akses" => 1, "id_user" => $id])->row_array();
        $grup = $this->db->get('tb_group_menu')->result_array();
        $sub = $this->M_pengaturan->tb_menu();
        $id = $this->session->id_user;
        $usr = $this->M_pengaturan->tb_akses($id);
        $this->load->view('header', ["grup" => $grup, "sub" => $sub, "usr" => $usr]);
        if (isset($akses['id'])) {
            $this->load->view('gudang/scan_cari');
        } else {
            $this->load->view('halaman_404');
        }
        $this->load->view('footer');
    }

    public function simpan_cari()
    {
        date_default_timezone_set('Asia/Jakarta');
        $id = $this->session->id_user;
        $kode = $this->input->post('kode_fg');
        $data = array(
            'no_lot' => $kode,
            'scan_time' => date('Y-m-d H:i:s'),
            'crid' => $id
        );
        $this->db->insert('tb_cari', $data);
    }

    public function tb_scan_cari()
    {
        $data = $this->M_gudang->tb_scan_cari();
        echo "<table class='table table-sm'>";
        echo "<thead>";
        echo "<th>#</th>";
        echo "<th>LOT</th>";
        echo "<th>Gudang asal</th>";
        echo "</thead>";
        echo "<tbody>";
        $i = 1;
        foreach ($data as $d) {
            if ($d['kode_fg'] == '') {
                echo "<tr class='table-danger'>";
                echo "<td>" . $i . "</td>";
                echo "<td>" . $d['no_lot'] . "</td>";
                echo "<td>" . $d['gudang'] . "</td>";
                echo "</tr>";
            } else {
                echo "<tr>";
                echo "<td>" . $i . "</td>";
                echo "<td>" . $d['no_lot'] . "</td>";
                echo "<td>" . $d['gudang'] . "</td>";
                echo "</tr>";
            }
            $i++;
        }
        echo "</tbody>";
        echo "</table>";
    }

    public function tb_scan_cari_xls()
    {
        $data = $this->M_gudang->tb_scan_cari();
        header("Pragma: public");
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Content-Type: application/force-download");
        header("Content-Type: application/octet-stream");
        header("Content-Type: application/download");
        header("Content-Disposition: attachment;filename= Master_Barang_LPBJ.xls");
        header("Content-Transfer-Encoding: binary ");
        echo "<table border='1' rules='all'>";
        echo "<thead>";
        echo "<th>#</th>";
        echo "<th>LOT</th>";
        echo "<th>ID Produksi</th>";
        echo "<th>SKU</th>";
        echo "<th>Barang</th>";
        echo "<th>Gudang asal</th>";
        echo "</thead>";
        echo "<tbody>";
        $i = 1;
        foreach ($data as $d) {
            echo "<tr>";
            echo "<td>" . $i . "</td>";
            echo "<td>" . $d['no_lot'] . "</td>";
            echo "<td>" . $d['id_produksi'] . "</td>";
            echo "<td>" . $d['sku'] . "</td>";
            echo "<td>" . $d['barang'] . "</td>";
            echo "<td>" . $d['gudang'] . "</td>";
            echo "</tr>";
            $i++;
        }
        echo "</tbody>";
        echo "</table>";
    }

    public function hapus_cari()
    {
        $this->db->query("truncate table tb_cari;");
    }

}
